/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;

public class HttpResponse {
    private final ResponseContext responseContext;
    private final ObjectMapper mapper;

    HttpResponse(ResponseContext context, ObjectMapper mapper) {
        this.responseContext = context;
        this.mapper = mapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <V> V readEntity(ObjectReader reader) {
        try {
            if (this.responseContext.getResponseCode().getCode() == Status.NO_CONTENT.getCode()) {
                return null;
            }
            try (InputStream is = this.responseContext.getInputStream();){
                Object object = reader.readValue(is);
                return (V)object;
            }
        }
        catch (IOException e) {
            throw new HttpClientException("Cannot parse request.", e);
        }
    }

    public <V> V readEntity(Class<V> clazz) {
        return this.readEntity(this.mapper.readerFor(clazz));
    }

    public <V> V readEntity(TypeReference<V> clazz) {
        return this.readEntity(this.mapper.readerFor(clazz));
    }
}

