/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import org.projectnessie.api.ConfigApi;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpConfigClient;
import org.projectnessie.client.http.HttpContentsClient;
import org.projectnessie.client.http.HttpTreeClient;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;

public class NessieHttpClient
implements NessieClient {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private final HttpClient client;
    private final ConfigApi config;
    private final TreeApi tree;
    private final ContentsApi contents;

    NessieHttpClient(URI uri, HttpAuthentication authentication, boolean enableTracing, int readTimeout, int connectionTimeoutMillis) {
        this.client = HttpClient.builder().setBaseUri(uri).setObjectMapper(this.mapper).setReadTimeoutMillis(readTimeout).setConnectionTimeoutMillis(connectionTimeoutMillis).build();
        if (enableTracing) {
            NessieHttpClient.addTracing(this.client);
        }
        if (authentication != null) {
            authentication.applyToHttpClient(this.client);
        }
        this.client.register(new NessieHttpResponseFilter(this.mapper));
        this.contents = this.wrap(ContentsApi.class, new HttpContentsClient(this.client));
        this.tree = this.wrap(TreeApi.class, new HttpTreeClient(this.client));
        this.config = this.wrap(ConfigApi.class, new HttpConfigClient(this.client));
    }

    private static void addTracing(HttpClient httpClient) {
        Tracer tracer = GlobalTracer.get();
        if (tracer != null) {
            httpClient.register(context -> {
                Span span = tracer.activeSpan();
                if (span != null) {
                    Span inner = tracer.buildSpan("Nessie-HTTP").start();
                    Scope scope = tracer.activateSpan(inner);
                    context.addResponseCallback((responseContext, exception) -> {
                        if (responseContext != null) {
                            try {
                                inner.setTag("http.status_code", (Number)responseContext.getResponseCode().getCode());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (exception != null) {
                            HashMap<String, String> log = new HashMap<String, String>();
                            log.put("event", Tags.ERROR.getKey());
                            log.put("error.object", exception.toString());
                            Tags.ERROR.set(inner.log(log), Boolean.valueOf(true));
                        }
                        scope.close();
                    });
                    inner.setTag("http.uri", context.getUri().toString()).setTag("http.method", context.getMethod().name());
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    TextMapAdapter httpHeadersCarrier = new TextMapAdapter(headerMap);
                    tracer.inject(inner.context(), Format.Builtin.HTTP_HEADERS, (Object)httpHeadersCarrier);
                    headerMap.forEach(context::putHeader);
                }
            });
        }
    }

    private <T> T wrap(Class<T> iface, T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ExceptionRewriter(delegate));
    }

    @Override
    public URI getUri() {
        return this.client.getBaseUri();
    }

    @Override
    public TreeApi getTreeApi() {
        return this.tree;
    }

    @Override
    public ContentsApi getContentsApi() {
        return this.contents;
    }

    @Override
    public ConfigApi getConfigApi() {
        return this.config;
    }

    @Override
    public void close() {
    }

    private static class ExceptionRewriter
    implements InvocationHandler {
        private final Object delegate;

        public ExceptionRewriter(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof HttpClientException) {
                    if (targetException.getCause() instanceof NessieNotFoundException) {
                        throw targetException.getCause();
                    }
                    if (targetException.getCause() instanceof NessieConflictException) {
                        throw targetException.getCause();
                    }
                }
                if (targetException instanceof RuntimeException) {
                    throw targetException;
                }
                throw ex;
            }
        }
    }
}

