/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.view.HasViewOperations;
import org.apache.iceberg.view.HistoryEntry;
import org.apache.iceberg.view.PropertiesUpdate;
import org.apache.iceberg.view.UpdateProperties;
import org.apache.iceberg.view.Version;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewOperations;

public class BaseView
implements View,
HasViewOperations {
    private final ViewOperations ops;
    private final String name;

    public BaseView(ViewOperations ops, String name) {
        this.ops = ops;
        this.name = name;
    }

    @Override
    public ViewOperations operations() {
        return this.ops;
    }

    @Override
    public Version currentVersion() {
        return this.ops.current().currentVersion();
    }

    @Override
    public Version version(int versionId) {
        return this.ops.current().version(versionId);
    }

    @Override
    public Iterable<Version> versions() {
        return this.ops.current().versions();
    }

    @Override
    public List<HistoryEntry> history() {
        return this.ops.current().history();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public UpdateProperties updateProperties() {
        return new PropertiesUpdate(this.ops);
    }

    @Override
    public Map<String, String> properties() {
        return Stream.of(this.ops.current().properties(), this.ops.extraProperties()).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> replacement));
    }
}

