/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import java.io.IOException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieError;

public class BaseNessieClientServerException
extends IOException {
    private final int status;
    private final String reason;
    private final String serverStackTrace;

    public BaseNessieClientServerException(String message, int status, String reason, Throwable cause) {
        super(message, cause);
        this.status = status;
        this.reason = reason;
        this.serverStackTrace = null;
    }

    public BaseNessieClientServerException(String message, int status, String reason) {
        super(message);
        this.status = status;
        this.reason = reason;
        this.serverStackTrace = null;
    }

    public BaseNessieClientServerException(NessieError error) {
        super(error.getMessage());
        this.status = error.getStatus();
        this.reason = error.getReason();
        this.serverStackTrace = error.getServerStackTrace();
    }

    public int getStatus() {
        return this.status;
    }

    public ErrorCode getErrorCode() {
        return ErrorCode.UNKNOWN;
    }

    public String getReason() {
        return this.reason;
    }

    public String getServerStackTrace() {
        return this.serverStackTrace;
    }
}

