/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.http;

import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.projectnessie.api.v1.NamespaceApi;
import org.projectnessie.api.v1.params.MultipleNamespacesParams;
import org.projectnessie.api.v1.params.NamespaceParams;
import org.projectnessie.api.v1.params.NamespaceUpdate;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.Namespace;

@Path(value="namespaces")
@Consumes(value={"application/json"})
public interface HttpNamespaceApi
extends NamespaceApi {
    @Override
    @PUT
    @Path(value="/namespace/{ref}/{name}")
    @Produces(value={"application/json"})
    @Operation(summary="Creates a Namespace")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned Namespace.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="namespace")}, schema=@Schema(implementation=Namespace.class))}), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to create namespace"), @APIResponse(responseCode="404", description="Reference not found"), @APIResponse(responseCode="409", description="Namespace already exists")})
    public Namespace createNamespace(@BeanParam @NotNull NamespaceParams var1, @NotNull @RequestBody Namespace var2) throws NessieNamespaceAlreadyExistsException, NessieReferenceNotFoundException;

    @Override
    @DELETE
    @Path(value="/namespace/{ref}/{name}")
    @Produces(value={"application/json"})
    @Operation(summary="Deletes a Namespace")
    @APIResponses(value={@APIResponse(responseCode="200", description="Namespace successfully deleted."), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to delete namespace"), @APIResponse(responseCode="404", description="Reference or Namespace not found"), @APIResponse(responseCode="409", description="Namespace not empty")})
    public void deleteNamespace(@BeanParam @NotNull NamespaceParams var1) throws NessieReferenceNotFoundException, NessieNamespaceNotEmptyException, NessieNamespaceNotFoundException;

    @Override
    @GET
    @Path(value="/namespace/{ref}/{name}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves a Namespace")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned Namespace.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="namespace")}, schema=@Schema(implementation=Namespace.class))}), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to retrieve namespace"), @APIResponse(responseCode="404", description="Reference or Namespace not found")})
    public Namespace getNamespace(@BeanParam @NotNull NamespaceParams var1) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException;

    @Override
    @GET
    @Path(value="/{ref}")
    @Produces(value={"application/json"})
    @APIResponses(value={@APIResponse(responseCode="200", description="Returns Namespaces with a given prefix.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="namespacesResponse")}, schema=@Schema(implementation=GetNamespacesResponse.class))}), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to retrieve namespaces"), @APIResponse(responseCode="404", description="Reference not found")})
    public GetNamespacesResponse getNamespaces(@BeanParam @NotNull MultipleNamespacesParams var1) throws NessieReferenceNotFoundException;

    @Override
    @POST
    @Path(value="/namespace/{ref}/{name}")
    @Produces(value={"application/json"})
    @APIResponses(value={@APIResponse(responseCode="200", description="Updates namespace properties for the given namespace."), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to update namespace properties"), @APIResponse(responseCode="404", description="Reference or Namespace not found")})
    public void updateProperties(@BeanParam @NotNull NamespaceParams var1, @RequestBody(description="Namespace properties to update/delete.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="namespaceUpdate")})}) @NotNull NamespaceUpdate var2) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException;
}

