/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v1.params.DiffParamsBuilder;

public class DiffParams {
    public static final String HASH_OPTIONAL_REGEX = "(^[0-9a-fA-F]{8,64}$)?";
    private static final char HASH_SEPARATOR = '*';
    @NotNull
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Parameter(description="The 'from' reference to start the diff from", examples={@ExampleObject(ref="ref")})
    private @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String fromRef;
    @Nullable
    @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="Optional hash on the 'from' reference to start the diff from", examples={@ExampleObject(ref="hash")})
    private @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes") String fromHashOnRef;
    @NotNull
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Parameter(description="The 'to' reference to end the diff at.", examples={@ExampleObject(ref="ref")})
    private @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String toRef;
    @Nullable
    @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="Optional hash on the 'to' reference to end the diff at.", examples={@ExampleObject(ref="hash")})
    private @Pattern(regexp="(^[0-9a-fA-F]{8,64}$)?", message="Hash must consist of the hex representation of 4-32 bytes") String toHashOnRef;

    public DiffParams() {
    }

    @Builder.Constructor
    DiffParams(@NotNull String fromRef, @Nullable String fromHashOnRef, @NotNull String toRef, @Nullable String toHashOnRef) {
        this.fromRef = fromRef;
        this.fromHashOnRef = fromHashOnRef;
        this.toRef = toRef;
        this.toHashOnRef = toHashOnRef;
    }

    @PathParam(value="fromRefWithHash")
    public void setFromRefWithHash(String value) {
        this.fromRef = this.parseRefName(value);
        this.fromHashOnRef = this.parseHash(value);
    }

    @PathParam(value="toRefWithHash")
    public void setToRefWithHash(String value) {
        this.toRef = this.parseRefName(value);
        this.toHashOnRef = this.parseHash(value);
    }

    private String parseRefName(String param) {
        int idx = param.indexOf(42);
        return idx == 0 ? null : (idx < 0 ? param : param.substring(0, idx));
    }

    private String parseHash(String param) {
        int idx = param.indexOf(42);
        return idx < 0 ? null : param.substring(idx + 1);
    }

    public String getFromRef() {
        return this.fromRef;
    }

    @Nullable
    public String getFromHashOnRef() {
        return DiffParams.emptyToNull(this.fromHashOnRef);
    }

    public String getToRef() {
        return this.toRef;
    }

    @Nullable
    public String getToHashOnRef() {
        return DiffParams.emptyToNull(this.toHashOnRef);
    }

    private static String emptyToNull(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.charAt(0) == '*') {
            if (s.length() == 1) {
                return null;
            }
            return s.substring(1);
        }
        return s;
    }

    public static DiffParamsBuilder builder() {
        return new DiffParamsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffParams)) {
            return false;
        }
        DiffParams that = (DiffParams)o;
        return Objects.equals(this.fromRef, that.fromRef) && Objects.equals(this.fromHashOnRef, that.fromHashOnRef) && Objects.equals(this.toRef, that.toRef) && Objects.equals(this.toHashOnRef, that.toHashOnRef);
    }

    public int hashCode() {
        return Objects.hash(this.fromRef, this.fromHashOnRef, this.toRef, this.toHashOnRef);
    }
}

