/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Util;

@JsonSerialize(as=ImmutableContentKey.class)
@JsonDeserialize(as=ImmutableContentKey.class)
@Value.Immutable
public abstract class ContentKey {
    @NotNull
    @Size(min=1)
    public abstract @NotNull @Size(min=1) List<String> getElements();

    @JsonIgnore
    @Value.Redacted
    public Namespace getNamespace() {
        return Namespace.of(this.getElements().subList(0, this.getElements().size() - 1));
    }

    @JsonIgnore
    @Value.Redacted
    public String getName() {
        return this.getElements().get(this.getElements().size() - 1);
    }

    public static ContentKey of(Namespace namespace, String name) {
        ImmutableContentKey.Builder b = ImmutableContentKey.builder();
        if (namespace != null && !namespace.isEmpty()) {
            b.elements(namespace.getElements());
        }
        return b.addElements(name).build();
    }

    public static ContentKey of(String ... elements) {
        Objects.requireNonNull(elements, "Elements array must not be null");
        return ImmutableContentKey.builder().addElements(elements).build();
    }

    @JsonCreator
    public static ContentKey of(@JsonProperty(value="elements") List<String> elements) {
        Objects.requireNonNull(elements);
        return ImmutableContentKey.builder().elements(elements).build();
    }

    @Value.Check
    protected void validate() {
        List<String> elements = this.getElements();
        for (String e : elements) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Content key '%s' must not contain a null element.", elements));
            }
            if (e.contains(Util.ZERO_BYTE_STRING) || e.contains(Util.GROUP_SEPARATOR_STRING)) {
                throw new IllegalArgumentException(String.format("Content key '%s' must not contain a zero byte (\\u0000) / group separator (\\u001D).", elements));
            }
            if (!e.isEmpty()) continue;
            throw new IllegalArgumentException(String.format("Content key '%s' must not contain an empty element.", elements));
        }
    }

    public static ContentKey fromPathString(String encoded) {
        return ContentKey.of(Util.fromPathString(encoded));
    }

    public String toPathString() {
        return Util.toPathString(this.getElements());
    }

    public String toString() {
        return String.join((CharSequence)".", this.getElements());
    }
}

