/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.function.Supplier;
import org.projectnessie.model.Branch;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.Reference;

public final class ReferenceResolver {
    public static final String DEFAULT_REF_IN_PATH = "-";

    private ReferenceResolver() {
    }

    public static Reference resolveReferencePathElement(String refPathString, Supplier<NessieConfiguration> config) {
        if (DEFAULT_REF_IN_PATH.equals(refPathString)) {
            return Branch.of(config.get().getDefaultBranch(), null);
        }
        return ReferenceResolver.resolveReferencePathElement(refPathString, Reference.ReferenceType.BRANCH);
    }

    public static Reference resolveReferencePathElement(String refPathString, Reference.ReferenceType type) {
        return Reference.fromPathString(refPathString, type);
    }
}

