/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.engine.config.DefaultJupiterConfiguration;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.projectnessie.junit.engine.EmptyConfigurationParameters;
import org.projectnessie.junit.engine.MultiEnvTestExtension;

public class MultiEnvExtensionRegistry {
    private final MutableExtensionRegistry registry = MutableExtensionRegistry.createRegistryWithDefaultExtensions((JupiterConfiguration)new DefaultJupiterConfiguration((ConfigurationParameters)new EmptyConfigurationParameters()));

    public void registerExtensions(Class<?> testClass) {
        AnnotationUtils.findRepeatableAnnotations(testClass, ExtendWith.class).stream().flatMap(e -> Arrays.stream(e.value())).filter(MultiEnvTestExtension.class::isAssignableFrom).forEach(arg_0 -> ((MutableExtensionRegistry)this.registry).registerExtension(arg_0));
    }

    public Stream<MultiEnvTestExtension> stream() {
        return this.registry.stream(MultiEnvTestExtension.class);
    }

    public Stream<? extends MultiEnvTestExtension> stream(Class<?> testClass) {
        return AnnotationUtils.findRepeatableAnnotations(testClass, ExtendWith.class).stream().flatMap(e -> Arrays.stream(e.value())).filter(MultiEnvTestExtension.class::isAssignableFrom).flatMap(arg_0 -> ((MutableExtensionRegistry)this.registry).stream(arg_0));
    }
}

