/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.junit.engine;

import java.util.ArrayList;
import java.util.Optional;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.jupiter.engine.config.CachingJupiterConfiguration;
import org.junit.jupiter.engine.config.DefaultJupiterConfiguration;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.projectnessie.junit.engine.MultiEnvExtensionRegistry;
import org.projectnessie.junit.engine.MultiEnvTestDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiEnvTestEngine
implements TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiEnvTestEngine.class);
    public static final String ENGINE_ID = "nessie-multi-env";
    private static final MultiEnvExtensionRegistry registry = new MultiEnvExtensionRegistry();
    private final JupiterTestEngine delegate = new JupiterTestEngine();

    static MultiEnvExtensionRegistry registry() {
        return registry;
    }

    public String getId() {
        return ENGINE_ID;
    }

    public void execute(ExecutionRequest request) {
        this.delegate.execute(request);
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        try {
            CachingJupiterConfiguration configuration = new CachingJupiterConfiguration((JupiterConfiguration)new DefaultJupiterConfiguration(discoveryRequest.getConfigurationParameters()));
            JupiterEngineDescriptor engineDescriptor = new JupiterEngineDescriptor(uniqueId, (JupiterConfiguration)configuration);
            TestDescriptor preliminaryResult = this.delegate.discover(discoveryRequest, uniqueId);
            preliminaryResult.accept(descriptor -> {
                if (descriptor instanceof ClassBasedTestDescriptor) {
                    Class testClass = ((ClassBasedTestDescriptor)descriptor).getTestClass();
                    registry.registerExtensions(testClass);
                }
            });
            registry.stream().forEach(ext -> {
                for (String envId : ext.allEnvironmentIds(discoveryRequest.getConfigurationParameters())) {
                    UniqueId segment = uniqueId.append(ext.segmentType(), envId);
                    MultiEnvTestDescriptor envRoot = new MultiEnvTestDescriptor(segment, envId);
                    engineDescriptor.addChild((TestDescriptor)envRoot);
                    TestDescriptor discoverResult = this.delegate.discover(discoveryRequest, segment);
                    ArrayList children = new ArrayList(discoverResult.getChildren());
                    for (TestDescriptor child : children) {
                        discoverResult.removeChild(child);
                        envRoot.addChild(child);
                    }
                }
            });
            return engineDescriptor;
        }
        catch (Exception e) {
            LOGGER.error("Failed to discover tests", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Optional<String> getGroupId() {
        return Optional.of("org.projectnessie");
    }

    public Optional<String> getArtifactId() {
        return Optional.of("nessie-compatibility-tools");
    }
}

