/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.projectnessie.api.v2.http.HttpTreeApi;
import org.projectnessie.api.v2.params.CommitLogParams;
import org.projectnessie.api.v2.params.DiffParams;
import org.projectnessie.api.v2.params.EntriesParams;
import org.projectnessie.api.v2.params.GetReferenceParams;
import org.projectnessie.api.v2.params.Merge;
import org.projectnessie.api.v2.params.ReferencesParams;
import org.projectnessie.api.v2.params.Transplant;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.ImmutableGetMultipleContentsRequest;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.SingleReferenceResponse;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.spi.ConfigService;
import org.projectnessie.services.spi.ContentService;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.services.spi.TreeService;

@RequestScoped
public class RestV2TreeResource
implements HttpTreeApi {
    private static final String DEFAULT_REF_IN_PATH = "-";
    private final ConfigService configService;
    private final TreeService treeService;
    private final ContentService contentService;
    private final DiffService diffService;

    public RestV2TreeResource() {
        this(null, null, null, null);
    }

    @Inject
    public RestV2TreeResource(ConfigService configService, TreeService treeService, ContentService contentService, DiffService diffService) {
        this.configService = configService;
        this.treeService = treeService;
        this.contentService = contentService;
        this.diffService = diffService;
    }

    private Reference resolveRef(String refPathString) {
        if (DEFAULT_REF_IN_PATH.equals(refPathString)) {
            return Branch.of((String)this.configService.getConfig().getDefaultBranch(), null);
        }
        return this.resolveRef(refPathString, Reference.ReferenceType.BRANCH);
    }

    private Reference resolveRef(String refPathString, Reference.ReferenceType type) {
        return Reference.fromPathString((String)refPathString, (Reference.ReferenceType)type);
    }

    private TreeService tree() {
        return this.treeService;
    }

    private DiffService diff() {
        return this.diffService;
    }

    private ContentService content() {
        return this.contentService;
    }

    @JsonView(value={Views.V2.class})
    public ReferencesResponse getAllReferences(ReferencesParams params) {
        return this.tree().getAllReferences(params.fetchOption(), params.filter());
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse createReference(String name, Reference.ReferenceType type, Reference reference) throws NessieNotFoundException, NessieConflictException {
        String fromRefName = null;
        String fromHash = null;
        if (reference != null) {
            fromRefName = reference.getName();
            fromHash = reference.getHash();
        }
        Reference created = this.tree().createReference(name, type, fromHash, fromRefName);
        return SingleReferenceResponse.builder().reference(created).build();
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        Reference reference = this.resolveRef(params.getRef());
        return SingleReferenceResponse.builder().reference(this.tree().getReferenceByName(reference.getName(), params.fetchOption())).build();
    }

    @JsonView(value={Views.V2.class})
    public EntriesResponse getEntries(String ref, EntriesParams params) throws NessieNotFoundException {
        Reference reference = this.resolveRef(ref);
        return this.tree().getEntries(reference.getName(), reference.getHash(), null, params.filter());
    }

    @JsonView(value={Views.V2.class})
    public LogResponse getCommitLog(String ref, CommitLogParams params) throws NessieNotFoundException {
        Reference reference = this.resolveRef(ref);
        return this.tree().getCommitLog(reference.getName(), params.fetchOption(), params.startHash(), reference.getHash(), params.filter(), params.maxRecords(), params.pageToken());
    }

    @JsonView(value={Views.V2.class})
    public DiffResponse getDiff(DiffParams params) throws NessieNotFoundException {
        Reference from = this.resolveRef(params.getFromRef());
        Reference to = this.resolveRef(params.getToRef());
        return this.diff().getDiff(from.getName(), from.getHash(), to.getName(), to.getHash());
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse assignReference(Reference.ReferenceType type, String ref, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        Reference reference = this.resolveRef(ref, type);
        Reference updated = this.tree().assignReference(type, reference.getName(), reference.getHash(), assignTo);
        return SingleReferenceResponse.builder().reference(updated).build();
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse deleteReference(Reference.ReferenceType type, String ref) throws NessieConflictException, NessieNotFoundException {
        Reference reference = this.resolveRef(ref, type);
        this.tree().deleteReference(type, reference.getName(), reference.getHash());
        return SingleReferenceResponse.builder().reference(reference).build();
    }

    @JsonView(value={Views.V2.class})
    public ContentResponse getContent(ContentKey key, String ref) throws NessieNotFoundException {
        Reference reference = this.resolveRef(ref);
        Content content = this.content().getContent(key, reference.getName(), reference.getHash());
        return ContentResponse.builder().content(content).build();
    }

    @JsonView(value={Views.V2.class})
    public GetMultipleContentsResponse getSeveralContents(String ref, List<String> keys) throws NessieNotFoundException {
        ImmutableGetMultipleContentsRequest.Builder request = GetMultipleContentsRequest.builder();
        keys.forEach(k -> request.addRequestedKeys(ContentKey.fromPathString((String)k)));
        return this.getMultipleContents(ref, (GetMultipleContentsRequest)request.build());
    }

    @JsonView(value={Views.V2.class})
    public GetMultipleContentsResponse getMultipleContents(String ref, GetMultipleContentsRequest request) throws NessieNotFoundException {
        Reference reference = this.resolveRef(ref);
        return this.content().getMultipleContents(reference.getName(), reference.getHash(), request.getRequestedKeys());
    }

    @JsonView(value={Views.V2.class})
    public MergeResponse transplantCommitsIntoBranch(String branch, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        Reference ref = this.resolveRef(branch);
        return this.tree().transplantCommitsIntoBranch(ref.getName(), ref.getHash(), transplant.getMessage(), transplant.getHashesToTransplant(), transplant.getFromRefName(), Boolean.valueOf(true), (Collection)transplant.getKeyMergeModes(), transplant.getDefaultKeyMergeMode(), transplant.isDryRun(), transplant.isFetchAdditionalInfo(), transplant.isReturnConflictAsResult());
    }

    @JsonView(value={Views.V2.class})
    public MergeResponse mergeRefIntoBranch(String branch, Merge merge) throws NessieNotFoundException, NessieConflictException {
        Reference ref = this.resolveRef(branch);
        return this.tree().mergeRefIntoBranch(ref.getName(), ref.getHash(), merge.getFromRefName(), merge.getFromHash(), Boolean.valueOf(false), merge.getMessage(), (Collection)merge.getKeyMergeModes(), merge.getDefaultKeyMergeMode(), merge.isDryRun(), merge.isFetchAdditionalInfo(), merge.isReturnConflictAsResult());
    }

    @JsonView(value={Views.V2.class})
    public CommitResponse commitMultipleOperations(String branch, Operations operations) throws NessieNotFoundException, NessieConflictException {
        Reference ref = this.resolveRef(branch);
        return this.tree().commitMultipleOperations(ref.getName(), ref.getHash(), operations);
    }
}

