/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.restjavax;

import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.restjavax.BaseExceptionMapper;

@Provider
public class ConstraintViolationExceptionMapper
extends BaseExceptionMapper<ConstraintViolationException> {
    public ConstraintViolationExceptionMapper() {
        this(null);
    }

    @Inject
    public ConstraintViolationExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(ConstraintViolationException exception) {
        ErrorCode errorCode = ErrorCode.BAD_REQUEST;
        for (ConstraintViolation violation : exception.getConstraintViolations()) {
            for (Path.Node node : violation.getPropertyPath()) {
                if (ElementKind.RETURN_VALUE != node.getKind()) continue;
                errorCode = ErrorCode.UNKNOWN;
            }
        }
        ConstraintViolationException canonical = new ConstraintViolationException(exception.getConstraintViolations());
        return this.buildExceptionResponse(errorCode, canonical.getMessage(), (Exception)exception, false, header -> {});
    }
}

