/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessierunner.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.projectnessie.nessierunner.common.InputBuffer;
import org.projectnessie.nessierunner.common.ListenUrlWaiter;

public class ProcessHandler {
    public static final long MILLIS_TO_HTTP_PORT = 30000L;
    public static final long MILLIS_TO_STOP = 15000L;
    private LongSupplier ticker = System::nanoTime;
    private static final int NOT_STARTED = -1;
    private static final int RUNNING = -2;
    private static final int ERROR = -3;
    private final AtomicInteger exitCode = new AtomicInteger(-1);
    private final AtomicBoolean stopped = new AtomicBoolean();
    private Process process;
    private long timeToListenUrlMillis = 30000L;
    private long timeStopMillis = 15000L;
    private Consumer<String> stdoutTarget = System.out::println;
    private Consumer<String> stderrTarget = System.err::println;
    private ListenUrlWaiter listenUrlWaiter;
    private volatile ExecutorService watchdogExecutor;
    private volatile Future<?> watchdogFuture;
    private volatile Thread shutdownHook;

    public ProcessHandler setTimeToListenUrlMillis(long timeToListenUrlMillis) {
        this.timeToListenUrlMillis = timeToListenUrlMillis;
        return this;
    }

    public ProcessHandler setTimeStopMillis(long timeStopMillis) {
        this.timeStopMillis = timeStopMillis;
        return this;
    }

    public ProcessHandler setStdoutTarget(Consumer<String> stdoutTarget) {
        this.stdoutTarget = stdoutTarget;
        return this;
    }

    public ProcessHandler setStderrTarget(Consumer<String> stderrTarget) {
        this.stderrTarget = stderrTarget;
        return this;
    }

    public ProcessHandler setTicker(LongSupplier ticker) {
        this.ticker = ticker;
        return this;
    }

    public ProcessHandler start(ProcessBuilder processBuilder) throws IOException {
        if (this.process != null) {
            throw new IllegalStateException("Process already started");
        }
        return this.started(processBuilder.start());
    }

    ProcessHandler started(Process process) {
        if (this.process != null) {
            throw new IllegalStateException("Process already started");
        }
        this.listenUrlWaiter = new ListenUrlWaiter(this.ticker, this.timeToListenUrlMillis, this.stdoutTarget);
        this.process = process;
        this.exitCode.set(-2);
        this.shutdownHook = new Thread(this::shutdownHandler);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.watchdogExecutor = Executors.newSingleThreadExecutor();
        this.watchdogFuture = this.watchdogExecutor.submit(this::watchdog);
        return this;
    }

    public String getListenUrl() throws InterruptedException, TimeoutException {
        return this.listenUrlWaiter.getListenUrl();
    }

    public void stop() {
        if (this.process == null) {
            throw new IllegalStateException("No process started");
        }
        this.doStop();
        this.watchdogExitGrace();
    }

    private void shutdownHandler() {
        this.doStop();
    }

    private void doStop() {
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.listenUrlWaiter.cancel();
                this.process.destroy();
                try {
                    if (!this.process.waitFor(this.timeStopMillis, TimeUnit.MILLISECONDS)) {
                        this.process.destroyForcibly();
                    }
                }
                catch (InterruptedException e) {
                    this.process.destroyForcibly();
                    Thread.currentThread().interrupt();
                }
                this.watchdogExecutor.shutdown();
            }
            finally {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    void watchdogExitGrace() {
        try {
            this.watchdogFuture.get(this.timeStopMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("ProcessHandler's watchdog thread failed.", e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("ProcessHandler's watchdog thread failed to finish in time.");
        }
        catch (InterruptedException e) {
            this.process.destroyForcibly();
            Thread.currentThread().interrupt();
        }
    }

    public boolean isAlive() {
        return this.exitCode.get() == -2;
    }

    public int getExitCode() throws IllegalThreadStateException {
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        return this.exitCode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object watchdog() throws IOException {
        block23: {
            try (InputStream out = this.process.getInputStream();
                 InputStream err = this.process.getErrorStream();){
                InputBuffer stdout = new InputBuffer(out, (Consumer<String>)this.listenUrlWaiter);
                InputBuffer stderr = new InputBuffer(err, this.stderrTarget);
                while (true) {
                    boolean anyIo;
                    do {
                        block22: {
                            anyIo = stdout.io();
                            anyIo |= stderr.io();
                            try {
                                int ec = this.process.exitValue();
                                this.exitCode.set(ec);
                                if (anyIo) break block22;
                                if (!this.stopped.get()) {
                                    this.stderrTarget.accept(String.format("Watched process exited with exit-code %d", ec));
                                }
                                break block23;
                            }
                            catch (IllegalThreadStateException ec) {
                                // empty catch block
                            }
                        }
                        if (!this.listenUrlWaiter.isTimeout() || this.stopped.get()) continue;
                        this.doStop();
                    } while (anyIo);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("ProcessHandler's watchdog thread interrupted, stopping process.");
                        this.doStop();
                        this.exitCode.set(-3);
                        break block23;
                    }
                }
                finally {
                    this.listenUrlWaiter.cancel();
                    stderr.flush();
                    stdout.flush();
                }
            }
        }
        return null;
    }
}

