/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessierunner.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.Consumer;

final class InputBuffer {
    private final Reader input;
    private final Consumer<String> output;
    private final StringBuilder lineBuffer = new StringBuilder();
    private boolean failed;

    InputBuffer(InputStream input, Consumer<String> output) {
        this(new BufferedReader(new InputStreamReader(input, Charset.defaultCharset())), output);
    }

    InputBuffer(Reader input, Consumer<String> output) {
        this.input = input;
        this.output = output;
    }

    boolean io() {
        try {
            if (this.failed || !this.input.ready()) {
                return false;
            }
            boolean any = false;
            while (this.input.ready()) {
                int c = this.input.read();
                if (c == -1) {
                    return any;
                }
                any = true;
                if (c == 13) continue;
                if (c == 10) {
                    this.output.accept(this.lineBuffer.toString());
                    this.lineBuffer.setLength(0);
                    continue;
                }
                this.lineBuffer.append((char)c);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.failed = true;
            return false;
        }
    }

    void flush() {
        if (this.lineBuffer.length() > 0) {
            this.output.accept(this.lineBuffer.toString());
            this.lineBuffer.setLength(0);
        }
    }
}

