/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessierunner.common;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ListenUrlWaiter
implements Consumer<String> {
    private static final Pattern HTTP_PORT_LOG_PATTERN = Pattern.compile("^.*Listening on: (http[s]?://[^ ]*)$");
    static final String TIMEOUT_MESSAGE = "Did not get the http(s) listen URL from the console output.";
    private static final long MAX_ITER_WAIT_NANOS = TimeUnit.MILLISECONDS.toNanos(50L);
    private final LongSupplier clock;
    private final Consumer<String> stdoutTarget;
    private final long deadlineListenUrl;
    private final CompletableFuture<String> listenUrl = new CompletableFuture();

    ListenUrlWaiter(LongSupplier clock, long timeToListenUrlMillis, Consumer<String> stdoutTarget) {
        this.clock = clock;
        this.stdoutTarget = stdoutTarget;
        this.deadlineListenUrl = clock.getAsLong() + TimeUnit.MILLISECONDS.toNanos(timeToListenUrlMillis);
    }

    @Override
    public void accept(String line) {
        Matcher m;
        if (!this.listenUrl.isDone() && (m = HTTP_PORT_LOG_PATTERN.matcher(line)).matches()) {
            this.listenUrl.complete(m.group(1));
        }
        this.stdoutTarget.accept(line);
    }

    String peekListenUrl() {
        try {
            return this.listenUrl.isDone() ? this.listenUrl.get() : null;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    String getListenUrl() throws InterruptedException, TimeoutException {
        while (true) {
            long remainingNanos;
            if ((remainingNanos = this.remainingNanos()) < 0L && !this.listenUrl.isDone()) {
                throw new TimeoutException(TIMEOUT_MESSAGE);
            }
            try {
                return this.listenUrl.get(Math.min(MAX_ITER_WAIT_NANOS, remainingNanos), TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            catch (CancellationException e) {
                throw new TimeoutException(TIMEOUT_MESSAGE);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            break;
        }
    }

    void cancel() {
        this.listenUrl.cancel(false);
    }

    private long remainingNanos() {
        return this.deadlineListenUrl - this.clock.getAsLong();
    }

    boolean isTimeout() {
        if (this.listenUrl.isDone() && !this.listenUrl.isCompletedExceptionally()) {
            return false;
        }
        return this.remainingNanos() < 0L;
    }
}

