/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessierunner.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ListenUrlWaiter
implements Consumer<String> {
    private static final Pattern HTTP_PORT_LOG_PATTERN = Pattern.compile("^.*Listening on: (http[s]?://[^ ]*)([.] Management interface listening on (http[s]?://[^ ]*)[.])?$");
    static final String TIMEOUT_MESSAGE = "Did not get the http(s) listen URL from the console output.";
    private static final long MAX_ITER_WAIT_NANOS = TimeUnit.MILLISECONDS.toNanos(50L);
    public static final String NOTHING_RECEIVED = " No output received from process.";
    public static final String CAPTURED_LOG_FOLLOWS = " Captured output follows:\n";
    private final LongSupplier clock;
    private final Consumer<String> stdoutTarget;
    private final long deadlineListenUrl;
    private final CompletableFuture<List<String>> listenUrl = new CompletableFuture();
    private final List<String> capturedLog = new ArrayList<String>();

    ListenUrlWaiter(LongSupplier clock, long timeToListenUrlMillis, Consumer<String> stdoutTarget) {
        this.clock = clock;
        this.stdoutTarget = stdoutTarget;
        this.deadlineListenUrl = clock.getAsLong() + TimeUnit.MILLISECONDS.toNanos(timeToListenUrlMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(String line) {
        if (!this.listenUrl.isDone()) {
            List<String> list = this.capturedLog;
            synchronized (list) {
                this.capturedLog.add(line);
                Matcher m = HTTP_PORT_LOG_PATTERN.matcher(line);
                if (m.matches()) {
                    this.listenUrl.complete(Arrays.asList(m.group(1), m.group(3)));
                    this.capturedLog.clear();
                }
            }
        }
        this.stdoutTarget.accept(line);
    }

    List<String> peekListenUrls() {
        try {
            return this.listenUrl.isDone() ? this.listenUrl.get() : null;
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    List<String> getListenUrls() throws InterruptedException, TimeoutException {
        while (true) {
            long remainingNanos;
            if ((remainingNanos = this.remainingNanos()) < 0L && !this.listenUrl.isDone()) {
                throw this.getTimeoutException(null);
            }
            try {
                return this.listenUrl.get(Math.min(MAX_ITER_WAIT_NANOS, remainingNanos), TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof TimeoutException) {
                    throw this.getTimeoutException(e.getCause());
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeoutException getTimeoutException(Throwable cause) {
        String log;
        List<String> list = this.capturedLog;
        synchronized (list) {
            log = String.join((CharSequence)"\n", this.capturedLog);
        }
        TimeoutException ex = new TimeoutException(TIMEOUT_MESSAGE + (log.isEmpty() ? NOTHING_RECEIVED : CAPTURED_LOG_FOLLOWS + log));
        if (cause != null) {
            ex.addSuppressed(cause);
        }
        return ex;
    }

    void stopped(String reason) {
        this.listenUrl.completeExceptionally(new RuntimeException(reason));
    }

    void timedOut() {
        this.listenUrl.completeExceptionally(new TimeoutException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exited(int exitCode) {
        String log;
        List<String> list = this.capturedLog;
        synchronized (list) {
            log = String.join((CharSequence)"\n", this.capturedLog);
        }
        this.listenUrl.completeExceptionally(new RuntimeException("Did not get the http(s) listen URL from the console output. Process exited early, exit code is " + exitCode + "." + (log.isEmpty() ? NOTHING_RECEIVED : CAPTURED_LOG_FOLLOWS + log)));
    }

    long remainingNanos() {
        return this.deadlineListenUrl - this.clock.getAsLong();
    }

    boolean isTimeout() {
        if (this.listenUrl.isDone() && !this.listenUrl.isCompletedExceptionally()) {
            return false;
        }
        return this.remainingNanos() < 0L;
    }
}

