/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessierunner.maven;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.projectnessie.nessierunner.common.JavaVM;
import org.projectnessie.nessierunner.common.ProcessHandler;
import org.projectnessie.nessierunner.maven.AbstractNessieRunnerMojo;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.NONE, threadSafe=true)
public class NessieRunnerStartMojo
extends AbstractNessieRunnerMojo {
    @Component
    private RepositorySystem repoSystem;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(property="nessie.apprunner.appArtifactId")
    private String appArtifactId;
    @Parameter
    private Properties systemProperties = new Properties();
    @Parameter
    private Properties environment;
    @Parameter
    private List<String> arguments;
    @Parameter
    private List<String> jvmArguments;
    @Parameter(defaultValue="11")
    private int javaVersion;
    @Parameter
    private String executableJar;
    @Parameter(defaultValue="quarkus.http.test-port")
    private String httpListenPortProperty;
    @Parameter(defaultValue="quarkus.http.test-url")
    private String httpListenUrlProperty;
    @Parameter(defaultValue="${build.directory}/nessie-quarkus")
    private String workingDirectory;
    @Parameter
    private long timeToListenUrlMillis;
    @Parameter
    private long timeToStopMillis;

    static String noJavaVMMessage(int version) {
        return String.format("Could not find a Java-VM for Java version %d. Either configure a type=jdk in Maven's toolchain with version=%d or set the Java-Home for a compatible JVM using the environment variable JDK%d_HOME or JAVA%d_HOME.", version, version, version, version);
    }

    public void execute() throws MojoExecutionException {
        String execJar;
        if (this.isSkipped()) {
            this.getLog().debug((CharSequence)"Execution is skipped");
            return;
        }
        this.getLog().debug((CharSequence)String.format("Searching for Java %d ...", this.javaVersion));
        String javaExecutable = this.toolchainManager.getToolchains(this.getSession(), "jdk", Collections.singletonMap("version", Integer.toString(this.javaVersion))).stream().map(tc -> tc.findTool("java")).findFirst().orElseGet(() -> {
            this.getLog().debug((CharSequence)String.format("... using JavaVM as Maven toolkit returned no toolchain for type==jdk and version==%d", this.javaVersion));
            JavaVM javaVM = JavaVM.findJavaVM((int)this.javaVersion);
            return javaVM != null ? javaVM.getJavaExecutable().toString() : null;
        });
        if (javaExecutable == null) {
            throw new MojoExecutionException(NessieRunnerStartMojo.noJavaVMMessage(this.javaVersion));
        }
        this.getLog().debug((CharSequence)String.format("Using javaExecutable %s", javaExecutable));
        Path workDir = Paths.get(this.workingDirectory, new String[0]);
        if (!Files.isDirectory(workDir, new LinkOption[0])) {
            try {
                Files.createDirectories(workDir, new FileAttribute[0]);
            }
            catch (IOException e2) {
                throw new MojoExecutionException(String.format("Failed to create working directory %s", this.workingDirectory), (Exception)e2);
            }
        }
        if ((execJar = this.executableJar) == null && this.appArtifactId == null) {
            if (this.getProject().getGroupId().equals("org.projectnessie")) {
                this.getLog().debug((CharSequence)"Nessie source-tree build.");
                MavenProject p = this.getProject().getParent();
                while (p.getGroupId().equals("org.projectnessie")) {
                    if (p.getArtifactId().equals("nessie")) {
                        this.getLog().info((CharSequence)"Using quarkus-run.jar from org.projectnessie source tree build");
                        execJar = p.getBasedir().toPath().resolve(Paths.get("servers", "quarkus-server", "target", "quarkus-app", "quarkus-run.jar")).toString();
                        break;
                    }
                    p = p.getParent();
                }
            }
            if (execJar == null) {
                throw new MojoExecutionException("Either appArtifactId or executableJar config option must be specified, prefer appArtifactId");
            }
        }
        if (execJar == null) {
            DefaultArtifact artifact = new DefaultArtifact(this.appArtifactId);
            ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)artifact, this.remoteRepos, null);
            try {
                ArtifactResult result = this.repoSystem.resolveArtifact(this.repoSession, artifactRequest);
                execJar = result.getArtifact().getFile().toString();
            }
            catch (ArtifactResolutionException e3) {
                throw new MojoExecutionException(String.format("Failed to resolve artifact %s", this.appArtifactId), (Exception)((Object)e3));
            }
        } else if (this.appArtifactId != null) {
            throw new MojoExecutionException("The options appArtifactId and executableJar are mutually exclusive");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaExecutable);
        if (this.jvmArguments != null) {
            command.addAll(this.jvmArguments);
        }
        if (this.systemProperties != null) {
            this.systemProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> command.add(String.format("-D%s=%s", k.toString(), v.toString()))));
        }
        command.add("-Dquarkus.http.port=0");
        command.add("-jar");
        command.add(execJar);
        if (this.arguments != null) {
            command.addAll(this.arguments);
        }
        this.getLog().info((CharSequence)String.format("Starting process: %s, additional env: %s", String.join((CharSequence)" ", command), this.environment != null ? this.environment.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(", ")) : "<none>"));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command);
        if (this.environment != null) {
            this.environment.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> processBuilder.environment().put(k.toString(), v.toString())));
        }
        processBuilder.directory(workDir.toFile());
        try {
            ProcessHandler processHandler = new ProcessHandler();
            if (this.timeToListenUrlMillis > 0L) {
                processHandler.setTimeToListenUrlMillis(this.timeToListenUrlMillis);
            }
            if (this.timeToStopMillis > 0L) {
                processHandler.setTimeStopMillis(this.timeToStopMillis);
            }
            processHandler.setStdoutTarget(line -> this.getLog().info((CharSequence)String.format("[stdout] %s", line)));
            processHandler.setStdoutTarget(line -> this.getLog().info((CharSequence)String.format("[stderr] %s", line)));
            processHandler.start(processBuilder);
            this.setApplicationHandle(processHandler);
            String listenUrl = processHandler.getListenUrl();
            Properties projectProperties = this.getProject().getProperties();
            projectProperties.setProperty(this.httpListenUrlProperty, listenUrl);
            projectProperties.setProperty(this.httpListenPortProperty, Integer.toString(URI.create(listenUrl).getPort()));
        }
        catch (InterruptedException e4) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(String.format("Process-start interrupted: %s", command), (Exception)e4);
        }
        catch (Exception e5) {
            throw new MojoExecutionException(String.format("Failed to start the process %s", command), e5);
        }
    }
}

