/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessierunner.maven;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.projectnessie.nessierunner.common.ProcessHandler;

abstract class AbstractNessieRunnerMojo
extends AbstractMojo {
    private static final String CONTEXT_KEY = "nessie.quarkus.app";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="nessie.apprunner.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="nessie.apprunner.executionId", required=false, defaultValue="default")
    private String executionId;

    AbstractNessieRunnerMojo() {
    }

    public boolean isSkipped() {
        return this.skip;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    private String getContextKey() {
        String key = "nessie.quarkus.app." + this.getExecutionId();
        return key;
    }

    protected ProcessHandler getApplication() {
        String key = this.getContextKey();
        return (ProcessHandler)this.project.getContextValue(key);
    }

    protected void resetApplication() {
        String key = this.getContextKey();
        this.project.setContextValue(key, null);
    }

    protected void setApplicationHandle(ProcessHandler application) {
        String key = this.getContextKey();
        Object previous = this.project.getContextValue(key);
        if (previous != null) {
            this.getLog().warn((CharSequence)String.format("Found a previous ProcessHandler for execution id %s.", this.getExecutionId()));
        }
        this.project.setContextValue(key, (Object)application);
    }
}

