/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessierunner.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.projectnessie.nessierunner.common.ProcessHandler;
import org.projectnessie.nessierunner.maven.AbstractNessieRunnerMojo;

@Mojo(name="stop", requiresDependencyResolution=ResolutionScope.NONE, threadSafe=true)
public class NessieRunnerStopMojo
extends AbstractNessieRunnerMojo {
    public void execute() throws MojoExecutionException {
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Stopping Quarkus application.");
            return;
        }
        ProcessHandler application = this.getApplication();
        if (application == null) {
            this.getLog().warn((CharSequence)String.format("No application found for execution id '%s'.", this.getExecutionId()));
            return;
        }
        try {
            application.stop();
            this.getLog().info((CharSequence)"Quarkus application stopped.");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while stopping Quarkus application", e);
        }
        finally {
            this.resetApplication();
        }
    }
}

