/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.ServerAccessContext;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServerAccessContext", generator="Immutables")
@Immutable
public final class ImmutableServerAccessContext
extends ServerAccessContext {
    private final String operationId;
    @Nullable
    private final Principal user;

    private ImmutableServerAccessContext(String operationId, @Nullable Principal user) {
        this.operationId = operationId;
        this.user = user;
    }

    @Override
    public String operationId() {
        return this.operationId;
    }

    @Override
    @Nullable
    public Principal user() {
        return this.user;
    }

    public final ImmutableServerAccessContext withOperationId(String value) {
        String newValue = Objects.requireNonNull(value, "operationId");
        if (this.operationId.equals(newValue)) {
            return this;
        }
        return new ImmutableServerAccessContext(newValue, this.user);
    }

    public final ImmutableServerAccessContext withUser(@Nullable Principal value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutableServerAccessContext(this.operationId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerAccessContext && this.equalTo(0, (ImmutableServerAccessContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableServerAccessContext another) {
        return this.operationId.equals(another.operationId) && Objects.equals(this.user, another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.operationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.user);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServerAccessContext").omitNullValues().add("operationId", (Object)this.operationId).add("user", (Object)this.user).toString();
    }

    public static ImmutableServerAccessContext copyOf(ServerAccessContext instance) {
        if (instance instanceof ImmutableServerAccessContext) {
            return (ImmutableServerAccessContext)instance;
        }
        return ImmutableServerAccessContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServerAccessContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OPERATION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String operationId;
        @Nullable
        private Principal user;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerAccessContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AccessContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Principal userValue;
            AccessContext instance;
            long bits = 0L;
            if (object instanceof ServerAccessContext) {
                instance = (ServerAccessContext)object;
                if ((bits & 1L) == 0L) {
                    this.operationId(((ServerAccessContext)instance).operationId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    userValue = ((ServerAccessContext)instance).user();
                    if (userValue != null) {
                        this.user(userValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof AccessContext) {
                instance = (AccessContext)object;
                if ((bits & 1L) == 0L) {
                    this.operationId(instance.operationId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    userValue = instance.user();
                    if (userValue != null) {
                        this.user(userValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder operationId(String operationId) {
            this.operationId = Objects.requireNonNull(operationId, "operationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder user(@Nullable Principal user) {
            this.user = user;
            return this;
        }

        public ImmutableServerAccessContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServerAccessContext(this.operationId, this.user);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("operationId");
            }
            return "Cannot build ServerAccessContext, some of required attributes are not set " + attributes;
        }
    }
}

