/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.cel;

import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.tools.ScriptHost;
import org.projectnessie.cel.types.jackson.JacksonRegistry;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableReferenceMetadata;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;

public class CELUtil {
    public static final String CONTAINER = "org.projectnessie.model";
    public static final ScriptHost SCRIPT_HOST = ScriptHost.newBuilder().registry(JacksonRegistry.newRegistry()).build();
    public static final String VAR_REF = "ref";
    public static final String VAR_REF_TYPE = "refType";
    public static final String VAR_REF_META = "refMeta";
    public static final String VAR_COMMIT = "commit";
    public static final String VAR_ENTRY = "entry";
    public static final String VAR_NAMESPACE = "namespace";
    public static final String VAR_CONTENT_TYPE = "contentType";
    public static final String VAR_PATH = "path";
    public static final String VAR_ROLE = "role";
    public static final String VAR_OP = "op";
    public static final String VAR_OPERATIONS = "operations";
    public static final List<Decl> REFERENCES_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"commit", (Type)Decls.newObjectType((String)CommitMeta.class.getName())), (Object)Decls.newVar((String)"ref", (Type)Decls.newObjectType((String)Reference.class.getName())), (Object)Decls.newVar((String)"refMeta", (Type)Decls.newObjectType((String)ReferenceMetadata.class.getName())), (Object)Decls.newVar((String)"refType", (Type)Decls.String));
    public static final List<Decl> COMMIT_LOG_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"commit", (Type)Decls.newObjectType((String)CommitMeta.class.getName())), (Object)Decls.newVar((String)"operations", (Type)Decls.newListType((Type)Decls.newObjectType((String)OperationForCel.class.getName()))));
    public static final List<Decl> ENTRIES_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"entry", (Type)Decls.newMapType((Type)Decls.String, (Type)Decls.String)), (Object)Decls.newVar((String)"namespace", (Type)Decls.String), (Object)Decls.newVar((String)"contentType", (Type)Decls.String));
    public static final List<Decl> AUTHORIZATION_RULE_DECLARATIONS = ImmutableList.of((Object)Decls.newVar((String)"ref", (Type)Decls.String), (Object)Decls.newVar((String)"path", (Type)Decls.String), (Object)Decls.newVar((String)"role", (Type)Decls.String), (Object)Decls.newVar((String)"op", (Type)Decls.String));
    public static final List<Object> COMMIT_LOG_TYPES = ImmutableList.of(CommitMeta.class, OperationForCel.class, ContentKey.class, Namespace.class);
    public static final List<Object> REFERENCES_TYPES = ImmutableList.of(CommitMeta.class, ReferenceMetadata.class, Reference.class);
    public static final CommitMeta EMPTY_COMMIT_META = CommitMeta.fromMessage((String)"");
    public static final ReferenceMetadata EMPTY_REFERENCE_METADATA = ImmutableReferenceMetadata.builder().commitMetaOfHEAD(EMPTY_COMMIT_META).build();

    public static Object forCel(Object model) {
        if (model instanceof Content) {
            final Content c = (Content)model;
            return new ContentForCel(){

                @Override
                public String getType() {
                    return c.getType().name();
                }

                @Override
                public String getId() {
                    return c.getId();
                }
            };
        }
        if (model instanceof Operation) {
            final Operation op = (Operation)model;
            return new OperationForCel(){

                @Override
                public String getType() {
                    if (op instanceof Operation.Put) {
                        return "PUT";
                    }
                    if (op instanceof Operation.Delete) {
                        return "DELETE";
                    }
                    return "OPERATION";
                }

                @Override
                public List<String> getKeyElements() {
                    return op.getKey().getElements();
                }

                @Override
                public String getKey() {
                    return op.getKey().toString();
                }

                @Override
                public String getNamespace() {
                    return op.getKey().getNamespace().name();
                }

                @Override
                public String[] getNamespaceElements() {
                    return op.getKey().getNamespace().getElements();
                }

                @Override
                public String getName() {
                    return op.getKey().getName();
                }

                @Override
                public ContentForCel getContent() {
                    if (op instanceof Operation.Put) {
                        return (ContentForCel)CELUtil.forCel(((Operation.Put)op).getContent());
                    }
                    return null;
                }

                public String toString() {
                    return op.toString();
                }
            };
        }
        return model;
    }

    public static interface ContentForCel {
        public String getType();

        public String getId();
    }

    public static interface OperationForCel {
        public String getType();

        public List<String> getKeyElements();

        public String getKey();

        public String[] getNamespaceElements();

        public String getName();

        public String getNamespace();

        public ContentForCel getContent();
    }
}

