/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.authz.ServerAccessContext;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

abstract class BaseApiImpl {
    private final ServerConfig config;
    private final VersionStore<Content, CommitMeta, Content.Type> store;
    private final AccessChecker accessChecker;
    private final Principal principal;

    protected BaseApiImpl(ServerConfig config, VersionStore<Content, CommitMeta, Content.Type> store, AccessChecker accessChecker, Principal principal) {
        this.config = config;
        this.store = store;
        this.accessChecker = accessChecker;
        this.principal = principal;
    }

    WithHash<NamedRef> namedRefWithHashOrThrow(@Nullable String namedRef, @Nullable String hashOnRef) throws NessieNotFoundException {
        WithHash namedRefWithHash;
        if (null == namedRef) {
            namedRef = this.config.getDefaultBranch();
        }
        try {
            WithHash refWithHash = this.getStore().toRef(namedRef);
            Ref ref = (Ref)refWithHash.getValue();
            if (!(ref instanceof NamedRef)) {
                throw new ReferenceNotFoundException(String.format("Named reference '%s' not found", namedRef));
            }
            namedRefWithHash = WithHash.of((Hash)refWithHash.getHash(), (Object)((NamedRef)ref));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        try {
            if (null == hashOnRef || this.store.noAncestorHash().asString().equals(hashOnRef)) {
                return namedRefWithHash;
            }
            if (namedRefWithHash.getHash().asString().equals(hashOnRef)) {
                return namedRefWithHash;
            }
            return WithHash.of((Hash)this.getStore().hashOnReference((NamedRef)namedRefWithHash.getValue(), Optional.of(Hash.of((String)hashOnRef))), (Object)((NamedRef)namedRefWithHash.getValue()));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    protected ServerConfig getConfig() {
        return this.config;
    }

    protected VersionStore<Content, CommitMeta, Content.Type> getStore() {
        return this.store;
    }

    protected Principal getPrincipal() {
        return this.principal;
    }

    protected AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    protected ServerAccessContext createAccessContext() {
        return ServerAccessContext.of(UUID.randomUUID().toString(), this.getPrincipal());
    }
}

