/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ContentApiImpl;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class ContentApiImplWithAuthorization
extends ContentApiImpl {
    public ContentApiImplWithAuthorization(ServerConfig config, VersionStore<Content, CommitMeta, Content.Type> store, AccessChecker accessChecker, Principal principal) {
        super(config, store, accessChecker, principal);
    }

    @Override
    public Content getContent(ContentKey key, String namedRef, String hashOnRef) throws NessieNotFoundException {
        NamedRef ref = (NamedRef)this.namedRefWithHashOrThrow(namedRef, hashOnRef).getValue();
        this.getAccessChecker().canReadEntityValue(this.createAccessContext(), ref, key, null);
        return super.getContent(key, namedRef, hashOnRef);
    }

    @Override
    public GetMultipleContentsResponse getMultipleContents(String namedRef, String hashOnRef, GetMultipleContentsRequest request) throws NessieNotFoundException {
        WithHash<NamedRef> ref = this.namedRefWithHashOrThrow(namedRef, hashOnRef);
        request.getRequestedKeys().forEach(k -> this.getAccessChecker().canReadEntityValue(this.createAccessContext(), (NamedRef)ref.getValue(), (ContentKey)k, null));
        return super.getMultipleContents(namedRef, hashOnRef, request);
    }
}

