/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import java.util.List;
import java.util.stream.Stream;
import org.projectnessie.api.DiffApi;
import org.projectnessie.api.params.DiffParams;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.ImmutableDiffEntry;
import org.projectnessie.model.ImmutableDiffResponse;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;

public class DiffApiImpl
extends BaseApiImpl
implements DiffApi {
    public DiffApiImpl(ServerConfig config, VersionStore<Content, CommitMeta, Content.Type> store, AccessChecker accessChecker, Principal principal) {
        super(config, store, accessChecker, principal);
    }

    public DiffResponse getDiff(DiffParams params) throws NessieNotFoundException {
        ImmutableDiffResponse.Builder builder = ImmutableDiffResponse.builder();
        try (Stream diffs = this.getStore().getDiffs((Ref)this.getStore().toRef(params.getFromRef()).getValue(), (Ref)this.getStore().toRef(params.getToRef()).getValue());){
            diffs.map(diff -> ImmutableDiffEntry.builder().key(ContentKey.of((List)diff.getKey().getElements())).from((Content)diff.getFromValue().orElse(null)).to((Content)diff.getToValue().orElse(null)).build()).forEach(arg_0 -> ((ImmutableDiffResponse.Builder)builder).addDiffs(arg_0));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        return builder.build();
    }
}

