/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.api.params.GetReferenceParams;
import org.projectnessie.api.params.ReferencesParams;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceAlreadyExistsException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableLogEntry;
import org.projectnessie.model.ImmutableLogResponse;
import org.projectnessie.model.ImmutableReferenceMetadata;
import org.projectnessie.model.ImmutableReferencesResponse;
import org.projectnessie.model.ImmutableTag;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Transplant;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.cel.CELUtil;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.impl.StreamUtil;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class TreeApiImpl
extends BaseApiImpl
implements TreeApi {
    private static final int MAX_COMMIT_LOG_ENTRIES = 250;

    public TreeApiImpl(ServerConfig config, VersionStore<Content, CommitMeta, Content.Type> store, AccessChecker accessChecker, Principal principal) {
        super(config, store, accessChecker, principal);
    }

    public ReferencesResponse getAllReferences(ReferencesParams params) {
        Preconditions.checkArgument((params.pageToken() == null ? 1 : 0) != 0, (Object)"Paging not supported");
        ImmutableReferencesResponse.Builder resp = ReferencesResponse.builder();
        boolean fetchAll = FetchOption.isFetchAll((FetchOption)params.fetchOption());
        try (Stream str = this.getStore().getNamedRefs(this.getGetNamedRefsParams(fetchAll));){
            Stream<Reference> unfiltered = str.map(refInfo -> TreeApiImpl.makeReference((ReferenceInfo<CommitMeta>)refInfo, fetchAll));
            Stream<Reference> filtered = this.filterReferences(unfiltered, params.filter());
            filtered.forEach(arg_0 -> ((ImmutableReferencesResponse.Builder)resp).addReferences(arg_0));
        }
        catch (ReferenceNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not find default branch '%s'.", this.getConfig().getDefaultBranch()));
        }
        return resp.build();
    }

    private GetNamedRefsParams getGetNamedRefsParams(boolean fetchMetadata) {
        return fetchMetadata ? GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)this.getConfig().getDefaultBranch())).branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.BASE_REFERENCE_RELATED_AND_COMMIT_META).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build() : GetNamedRefsParams.DEFAULT;
    }

    private Stream<Reference> filterReferences(Stream<Reference> references, String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return references;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.REFERENCES_DECLARATIONS).withTypes(CELUtil.REFERENCES_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return references.filter(reference -> {
            try {
                CommitMeta commit;
                ReferenceMetadata refMeta = reference.getMetadata();
                if (refMeta == null) {
                    refMeta = CELUtil.EMPTY_REFERENCE_METADATA;
                }
                if ((commit = refMeta.getCommitMetaOfHEAD()) == null) {
                    commit = CELUtil.EMPTY_COMMIT_META;
                }
                String refType = reference instanceof Branch ? "BRANCH" : (reference instanceof Tag ? "TAG" : "REFERENCE");
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"ref", (Object)reference, (Object)"refType", (Object)refType, (Object)"commit", (Object)commit, (Object)"refMeta", (Object)refMeta));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Reference getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        try {
            boolean fetchAll = FetchOption.isFetchAll((FetchOption)params.fetchOption());
            return TreeApiImpl.makeReference((ReferenceInfo<CommitMeta>)this.getStore().getNamedRef(params.getRefName(), this.getGetNamedRefsParams(fetchAll)), fetchAll);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public Reference createReference(String sourceRefName, Reference reference) throws NessieNotFoundException, NessieConflictException {
        if (reference instanceof Branch) {
            BranchName namedReference = BranchName.of((String)reference.getName());
            Hash hash = this.createReference((NamedRef)namedReference, reference.getHash());
            return Branch.of((String)reference.getName(), (String)hash.asString());
        }
        if (reference instanceof Tag) {
            TagName namedReference = TagName.of((String)reference.getName());
            Hash hash = this.createReference((NamedRef)namedReference, reference.getHash());
            return Tag.of((String)reference.getName(), (String)hash.asString());
        }
        throw new IllegalArgumentException("Only tag and branch references can be created.");
    }

    private Hash createReference(NamedRef reference, String hash) throws NessieNotFoundException, NessieReferenceAlreadyExistsException {
        if (reference instanceof TagName && hash == null) {
            throw new IllegalArgumentException("Tag-creation requires a target named-reference and hash.");
        }
        try {
            return this.getStore().create(reference, TreeApiImpl.toHash(hash, false));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceAlreadyExistsException e) {
            throw new NessieReferenceAlreadyExistsException(e.getMessage(), (Throwable)e);
        }
    }

    public Branch getDefaultBranch() throws NessieNotFoundException {
        Reference r = this.getReferenceByName(GetReferenceParams.builder().refName(this.getConfig().getDefaultBranch()).build());
        if (!(r instanceof Branch)) {
            throw new IllegalStateException("Default branch isn't a branch");
        }
        return (Branch)r;
    }

    public void assignTag(String tagName, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.assignReference((NamedRef)TagName.of((String)tagName), expectedHash, assignTo);
    }

    public void deleteTag(String tagName, String hash) throws NessieConflictException, NessieNotFoundException {
        this.deleteReference((NamedRef)TagName.of((String)tagName), hash);
    }

    public void assignBranch(String branchName, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.assignReference((NamedRef)BranchName.of((String)branchName), expectedHash, assignTo);
    }

    public void deleteBranch(String branchName, String hash) throws NessieConflictException, NessieNotFoundException {
        this.deleteReference((NamedRef)BranchName.of((String)branchName), hash);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LogResponse getCommitLog(String namedRef, CommitLogParams params) throws NessieNotFoundException {
        int max = Math.min(params.maxRecords() != null ? params.maxRecords() : 250, 250);
        Hash endRef = this.namedRefWithHashOrThrow(namedRef, null == params.pageToken() ? params.endHash() : params.pageToken()).getHash();
        boolean fetchAll = FetchOption.isFetchAll((FetchOption)params.fetchOption());
        try (Stream commits = this.getStore().getCommits((Ref)endRef, fetchAll);){
            Stream<LogResponse.LogEntry> logEntries = commits.map(commit -> {
                CommitMeta commitMetaWithHash = TreeApiImpl.addHashToCommitMeta(commit.getHash(), (CommitMeta)commit.getCommitMeta());
                ImmutableLogEntry.Builder logEntry = LogResponse.LogEntry.builder();
                logEntry.commitMeta(commitMetaWithHash);
                if (fetchAll) {
                    if (commit.getParentHash() != null) {
                        logEntry.parentCommitHash(commit.getParentHash().asString());
                    }
                    if (commit.getOperations() != null) {
                        commit.getOperations().forEach(op -> {
                            ContentKey key = ContentKey.of((List)op.getKey().getElements());
                            if (op instanceof Put) {
                                Content content = (Content)((Put)op).getValue();
                                logEntry.addOperations((org.projectnessie.model.Operation)Operation.Put.of((ContentKey)key, (Content)content));
                            }
                            if (op instanceof Delete) {
                                logEntry.addOperations((org.projectnessie.model.Operation)Operation.Delete.of((ContentKey)key));
                            }
                        });
                    }
                }
                return logEntry.build();
            });
            logEntries = StreamSupport.stream(StreamUtil.takeUntilIncl(logEntries.spliterator(), x -> Objects.equals(x.getCommitMeta().getHash(), params.startHash())), false);
            List items = this.filterCommitLog(logEntries, params.filter()).limit(max + 1).collect(Collectors.toList());
            if (items.size() == max + 1) {
                ImmutableLogResponse immutableLogResponse2 = ImmutableLogResponse.builder().addAllLogEntries(items.subList(0, max)).isHasMore(true).token(((LogResponse.LogEntry)items.get(max)).getCommitMeta().getHash()).build();
                return immutableLogResponse2;
            }
            ImmutableLogResponse immutableLogResponse = ImmutableLogResponse.builder().addAllLogEntries(items).build();
            return immutableLogResponse;
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    private static CommitMeta addHashToCommitMeta(Hash hash, CommitMeta commitMeta) {
        return commitMeta.toBuilder().hash(hash.asString()).build();
    }

    private Stream<LogResponse.LogEntry> filterCommitLog(Stream<LogResponse.LogEntry> logEntries, String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return logEntries;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.COMMIT_LOG_DECLARATIONS).withTypes(CELUtil.COMMIT_LOG_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return logEntries.filter(logEntry -> {
            try {
                List operations = logEntry.getOperations();
                if (operations == null) {
                    operations = Collections.emptyList();
                }
                List operationsForCel = operations.stream().map(CELUtil::forCel).collect(Collectors.toList());
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"commit", (Object)logEntry.getCommitMeta(), (Object)"operations", operationsForCel));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void transplantCommitsIntoBranch(String branchName, String hash, String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        try {
            List transplants;
            try (Stream<Hash> s = transplant.getHashesToTransplant().stream().map(Hash::of);){
                transplants = s.collect(Collectors.toList());
            }
            this.getStore().transplant(BranchName.of((String)branchName), TreeApiImpl.toHash(hash, true), transplants, this.rewriteCommitMetadataForMergeTransplant());
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    public void mergeRefIntoBranch(String branchName, String hash, Merge merge) throws NessieNotFoundException, NessieConflictException {
        try {
            this.getStore().merge(this.toHash(merge.getFromRefName(), merge.getFromHash()), BranchName.of((String)branchName), TreeApiImpl.toHash(hash, true), this.rewriteCommitMetadataForMergeTransplant());
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    private Function<CommitMeta, CommitMeta> rewriteCommitMetadataForMergeTransplant() {
        Instant now = Instant.now();
        return commitMeta -> ImmutableCommitMeta.builder().from(commitMeta).commitTime(now).build();
    }

    public EntriesResponse getEntries(String namedRef, EntriesParams params) throws NessieNotFoundException {
        Preconditions.checkArgument((params.pageToken() == null ? 1 : 0) != 0, (Object)"Paging not supported");
        WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(namedRef, params.hashOnRef());
        try {
            List entries;
            try (Stream<EntriesResponse.Entry> entryStream = this.getStore().getKeys((Ref)refWithHash.getHash()).map(key -> EntriesResponse.Entry.builder().name(TreeApiImpl.fromKey((Key)key.getValue())).type((Content.Type)key.getType()).build());){
                Stream<EntriesResponse.Entry> entriesStream = this.filterEntries(entryStream, params.filter());
                if (params.namespaceDepth() != null && params.namespaceDepth() > 0) {
                    entriesStream = entriesStream.filter(e -> e.getName().getElements().size() >= params.namespaceDepth()).map(e -> this.truncate((EntriesResponse.Entry)e, params.namespaceDepth())).distinct();
                }
                entries = (List)entriesStream.collect(ImmutableList.toImmutableList());
            }
            return EntriesResponse.builder().addAllEntries((Iterable)entries).build();
        }
        catch (ReferenceNotFoundException e2) {
            throw new NessieReferenceNotFoundException(e2.getMessage(), (Throwable)e2);
        }
    }

    private EntriesResponse.Entry truncate(EntriesResponse.Entry entry, Integer depth) {
        if (depth == null || depth < 1) {
            return entry;
        }
        Content.Type type = entry.getName().getElements().size() > depth ? Content.Type.UNKNOWN : entry.getType();
        ContentKey key = ContentKey.of(entry.getName().getElements().subList(0, depth));
        return EntriesResponse.Entry.builder().type(type).name(key).build();
    }

    private Stream<EntriesResponse.Entry> filterEntries(Stream<EntriesResponse.Entry> entries, String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return entries;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.ENTRIES_DECLARATIONS).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return entries.filter(entry -> {
            ImmutableMap arguments = ImmutableMap.of((Object)"entry", (Object)ImmutableMap.of((Object)"namespace", (Object)entry.getName().getNamespace().name(), (Object)"contentType", (Object)entry.getType().name()));
            try {
                return (Boolean)script.execute(Boolean.class, (Map)arguments);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Branch commitMultipleOperations(String branch, String hash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        List ops = (List)operations.getOperations().stream().map(TreeApiImpl::toOp).collect(ImmutableList.toImmutableList());
        String newHash = this.doOps(branch, hash, operations.getCommitMeta(), ops).asString();
        return Branch.of((String)branch, (String)newHash);
    }

    protected Hash doOps(String branch, String hash, CommitMeta commitMeta, List<Operation<Content>> operations) throws NessieConflictException, NessieNotFoundException {
        try {
            return this.getStore().commit(BranchName.of((String)Optional.ofNullable(branch).orElse(this.getConfig().getDefaultBranch())), Optional.ofNullable(hash).map(Hash::of), (Object)TreeApiImpl.meta(this.getPrincipal(), commitMeta), operations);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    private static CommitMeta meta(Principal principal, CommitMeta commitMeta) {
        if (commitMeta.getCommitter() != null) {
            throw new IllegalArgumentException("Cannot set the committer on the client side. It is set by the server.");
        }
        String committer = principal == null ? "" : principal.getName();
        Instant now = Instant.now();
        return commitMeta.toBuilder().committer(committer).commitTime(now).author(commitMeta.getAuthor() == null ? committer : commitMeta.getAuthor()).authorTime(commitMeta.getAuthorTime() == null ? now : commitMeta.getAuthorTime()).build();
    }

    private Hash toHash(String referenceName, String hashOnReference) throws ReferenceNotFoundException {
        if (hashOnReference == null) {
            WithHash hash = this.getStore().toRef(referenceName);
            return hash.getHash();
        }
        return TreeApiImpl.toHash(hashOnReference, true).orElseThrow(() -> new IllegalStateException("Required hash is missing"));
    }

    private static Optional<Hash> toHash(String hash, boolean required) {
        if (hash == null || hash.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException("Must provide expected hash value for operation.");
            }
            return Optional.empty();
        }
        return Optional.of(Hash.of((String)hash));
    }

    protected void deleteReference(NamedRef ref, String hash) throws NessieConflictException, NessieNotFoundException {
        try {
            this.getStore().delete(ref, TreeApiImpl.toHash(hash, true));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    protected void assignReference(NamedRef ref, String oldHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        try {
            WithHash resolved = this.getStore().toRef(ref.getName());
            Ref resolvedRef = (Ref)resolved.getValue();
            if (!(resolvedRef instanceof NamedRef)) {
                throw new IllegalArgumentException("Can only assign branch and tag types.");
            }
            this.getStore().assign((NamedRef)resolvedRef, TreeApiImpl.toHash(oldHash, true), this.toHash(assignTo.getName(), assignTo.getHash()));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    private static ContentKey fromKey(Key key) {
        return ContentKey.of((List)key.getElements());
    }

    private static Reference makeReference(ReferenceInfo<CommitMeta> refWithHash, boolean fetchMetadata) {
        NamedRef ref = refWithHash.getNamedRef();
        if (ref instanceof TagName) {
            ImmutableTag.Builder builder = ImmutableTag.builder().name(ref.getName()).hash(refWithHash.getHash().asString());
            if (fetchMetadata) {
                builder.metadata(TreeApiImpl.extractReferenceMetadata(refWithHash));
            }
            return builder.build();
        }
        if (ref instanceof BranchName) {
            ImmutableBranch.Builder builder = ImmutableBranch.builder().name(ref.getName()).hash(refWithHash.getHash().asString());
            if (fetchMetadata) {
                builder.metadata(TreeApiImpl.extractReferenceMetadata(refWithHash));
            }
            return builder.build();
        }
        throw new UnsupportedOperationException("only converting tags or branches");
    }

    @Nullable
    private static ReferenceMetadata extractReferenceMetadata(ReferenceInfo<CommitMeta> refWithHash) {
        ImmutableReferenceMetadata.Builder builder = ImmutableReferenceMetadata.builder();
        boolean found = false;
        if (null != refWithHash.getAheadBehind()) {
            found = true;
            builder.numCommitsAhead(Integer.valueOf(refWithHash.getAheadBehind().getAhead()));
            builder.numCommitsBehind(Integer.valueOf(refWithHash.getAheadBehind().getBehind()));
        }
        if (null != refWithHash.getHeadCommitMeta()) {
            found = true;
            builder.commitMetaOfHEAD(TreeApiImpl.addHashToCommitMeta(refWithHash.getHash(), (CommitMeta)refWithHash.getHeadCommitMeta()));
        }
        if (0L != refWithHash.getCommitSeq()) {
            found = true;
            builder.numTotalCommits(Long.valueOf(refWithHash.getCommitSeq()));
        }
        if (null != refWithHash.getCommonAncestor()) {
            found = true;
            builder.commonAncestorHash(refWithHash.getCommonAncestor().asString());
        }
        if (!found) {
            return null;
        }
        return builder.build();
    }

    protected static Operation<Content> toOp(org.projectnessie.model.Operation o) {
        Key key = Key.of((String[])o.getKey().getElements().toArray(new String[0]));
        if (o instanceof Operation.Delete) {
            return Delete.of((Key)key);
        }
        if (o instanceof Operation.Put) {
            Operation.Put put = (Operation.Put)o;
            return put.getExpectedContent() != null ? Put.of((Key)key, (Object)put.getContent(), (Object)put.getExpectedContent()) : Put.of((Key)key, (Object)put.getContent());
        }
        if (o instanceof Operation.Unchanged) {
            return Unchanged.of((Key)key);
        }
        throw new IllegalStateException("Unknown operation " + o);
    }
}

