/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.AccessControlException;
import java.security.Principal;
import javax.annotation.Nullable;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.api.params.GetReferenceParams;
import org.projectnessie.api.params.ReferencesParams;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ImmutableReferencesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Transplant;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.authz.ServerAccessContext;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStore;

public class TreeApiImplWithAuthorization
extends TreeApiImpl {
    public TreeApiImplWithAuthorization(ServerConfig config, VersionStore<Content, CommitMeta, Content.Type> store, AccessChecker accessChecker, Principal principal) {
        super(config, store, accessChecker, principal);
    }

    @Override
    public ReferencesResponse getAllReferences(ReferencesParams params) {
        ServerAccessContext accessContext = this.createAccessContext();
        ImmutableReferencesResponse.Builder resp = ReferencesResponse.builder();
        super.getAllReferences(params).getReferences().stream().filter(ref -> {
            try {
                if (ref instanceof Branch) {
                    this.getAccessChecker().canViewReference(accessContext, (NamedRef)BranchName.of((String)ref.getName()));
                } else if (ref instanceof Tag) {
                    this.getAccessChecker().canViewReference(accessContext, (NamedRef)TagName.of((String)ref.getName()));
                }
                return true;
            }
            catch (AccessControlException e) {
                return false;
            }
        }).forEach(arg_0 -> ((ImmutableReferencesResponse.Builder)resp).addReferences(arg_0));
        return resp.build();
    }

    @Override
    public Reference getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        Reference ref = super.getReferenceByName(params);
        if (ref instanceof Branch) {
            this.getAccessChecker().canViewReference(this.createAccessContext(), (NamedRef)BranchName.of((String)ref.getName()));
        } else if (ref instanceof Tag) {
            this.getAccessChecker().canViewReference(this.createAccessContext(), (NamedRef)TagName.of((String)ref.getName()));
        }
        return ref;
    }

    @Override
    public Reference createReference(@Nullable String sourceRefName, Reference reference) throws NessieNotFoundException, NessieConflictException {
        block5: {
            if (reference instanceof Branch) {
                this.getAccessChecker().canCreateReference(this.createAccessContext(), (NamedRef)BranchName.of((String)reference.getName()));
            } else if (reference instanceof Tag) {
                this.getAccessChecker().canCreateReference(this.createAccessContext(), (NamedRef)TagName.of((String)reference.getName()));
            }
            try {
                this.getAccessChecker().canViewReference(this.createAccessContext(), (NamedRef)this.namedRefWithHashOrThrow(sourceRefName, reference.getHash()).getValue());
            }
            catch (NessieNotFoundException e) {
                if (reference instanceof Branch && reference.getName().equals(this.getConfig().getDefaultBranch()) && (null == reference.getHash() || this.getStore().noAncestorHash().asString().equals(reference.getHash()))) break block5;
                throw e;
            }
        }
        return super.createReference(sourceRefName, reference);
    }

    @Override
    protected void assignReference(NamedRef ref, String oldHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.namedRefWithHashOrThrow(assignTo.getName(), assignTo.getHash());
        this.getAccessChecker().canAssignRefToHash(this.createAccessContext(), ref);
        super.assignReference(ref, oldHash, assignTo);
    }

    @Override
    protected void deleteReference(NamedRef ref, String hash) throws NessieConflictException, NessieNotFoundException {
        this.getAccessChecker().canDeleteReference(this.createAccessContext(), ref);
        super.deleteReference(ref, hash);
    }

    @Override
    public EntriesResponse getEntries(String namedRef, EntriesParams params) throws NessieNotFoundException {
        this.getAccessChecker().canReadEntries(this.createAccessContext(), (NamedRef)this.namedRefWithHashOrThrow(namedRef, params.hashOnRef()).getValue());
        return super.getEntries(namedRef, params);
    }

    @Override
    public LogResponse getCommitLog(String namedRef, CommitLogParams params) throws NessieNotFoundException {
        if (null == params.pageToken()) {
            this.getAccessChecker().canListCommitLog(this.createAccessContext(), (NamedRef)this.namedRefWithHashOrThrow(namedRef, params.endHash()).getValue());
        }
        return super.getCommitLog(namedRef, params);
    }

    @Override
    public void transplantCommitsIntoBranch(String branchName, String hash, String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        if (transplant.getHashesToTransplant().isEmpty()) {
            throw new IllegalArgumentException("No hashes given to transplant.");
        }
        this.namedRefWithHashOrThrow(transplant.getFromRefName(), (String)transplant.getHashesToTransplant().get(transplant.getHashesToTransplant().size() - 1));
        this.getAccessChecker().canCommitChangeAgainstReference(this.createAccessContext(), (NamedRef)BranchName.of((String)branchName));
        super.transplantCommitsIntoBranch(branchName, hash, message, transplant);
    }

    @Override
    public void mergeRefIntoBranch(String branchName, String hash, Merge merge) throws NessieNotFoundException, NessieConflictException {
        this.getAccessChecker().canCommitChangeAgainstReference(this.createAccessContext(), (NamedRef)BranchName.of((String)branchName));
        super.mergeRefIntoBranch(branchName, hash, merge);
    }

    @Override
    public Branch commitMultipleOperations(String branch, String hash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        BranchName branchName = BranchName.of((String)branch);
        ServerAccessContext accessContext = this.createAccessContext();
        this.getAccessChecker().canCommitChangeAgainstReference(accessContext, (NamedRef)branchName);
        operations.getOperations().forEach(op -> {
            if (op instanceof Operation.Delete) {
                this.getAccessChecker().canDeleteEntity(accessContext, (NamedRef)branchName, op.getKey(), null);
            } else if (op instanceof Operation.Put) {
                this.getAccessChecker().canUpdateEntity(accessContext, (NamedRef)branchName, op.getKey(), null);
            }
        });
        return super.commitMultipleOperations(branch, hash, operations);
    }
}

