/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.projectnessie.api.NamespaceApi;
import org.projectnessie.api.params.MultipleNamespacesParams;
import org.projectnessie.api.params.NamespaceParams;
import org.projectnessie.api.params.NamespaceUpdate;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.ImmutableGetNamespacesResponse;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class NamespaceApiImpl
extends BaseApiImpl
implements NamespaceApi {
    public NamespaceApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Principal principal) {
        super(config, store, authorizer, principal);
    }

    public Namespace createNamespace(NamespaceParams params, Namespace namespace) throws NessieNamespaceAlreadyExistsException, NessieReferenceNotFoundException {
        Preconditions.checkArgument((!namespace.isEmpty() ? 1 : 0) != 0, (Object)"Namespace name must not be empty");
        WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(params.getRefName(), null);
        try {
            Callable<Void> validator = () -> {
                Optional<Content> explicitlyCreatedNamespace = this.getExplicitlyCreatedNamespace(namespace, refWithHash.getHash());
                if (explicitlyCreatedNamespace.isPresent()) {
                    Namespace ignored = (Namespace)explicitlyCreatedNamespace.get().unwrap(Namespace.class).orElseThrow(() -> NamespaceApiImpl.otherContentAlreadyExistsException(namespace));
                    throw NamespaceApiImpl.namespaceAlreadyExistsException(namespace);
                }
                if (this.getImplicitlyCreatedNamespace(namespace, refWithHash.getHash()).isPresent()) {
                    throw NamespaceApiImpl.namespaceAlreadyExistsException(namespace);
                }
                return null;
            };
            ContentKey key = ContentKey.of((List)namespace.getElements());
            Operation.Put put = Operation.Put.of((ContentKey)key, (Content)namespace);
            Hash hash = this.commit(BranchName.of((String)((NamedRef)refWithHash.getValue()).getName()), "create namespace " + namespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)put), validator);
            Content content = this.getExplicitlyCreatedNamespace(namespace, hash).orElse(null);
            Preconditions.checkState((boolean)(content instanceof Namespace), (String)"Expected %s to return the created Namespace, but got %s", (Object)key, (Object)content);
            return (Namespace)content;
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    public void deleteNamespace(NamespaceParams params) throws NessieReferenceNotFoundException, NessieNamespaceNotEmptyException, NessieNamespaceNotFoundException {
        WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(params.getRefName(), null);
        try {
            Namespace namespace = this.getNamespace(params.getNamespace(), refWithHash.getHash());
            Operation.Delete delete = Operation.Delete.of((ContentKey)ContentKey.of((List)namespace.getElements()));
            Callable<Void> validator = () -> {
                try (Stream keys = this.getStore().getKeys((Ref)refWithHash.getHash());){
                    if (keys.anyMatch(k -> Namespace.of((List)k.getKey().getElements()).isSameOrSubElementOf(params.getNamespace()) && !k.getType().equals(Content.Type.NAMESPACE))) {
                        throw NamespaceApiImpl.namespaceNotEmptyException(params.getNamespace());
                    }
                }
                return null;
            };
            this.commit(BranchName.of((String)((NamedRef)refWithHash.getValue()).getName()), "delete namespace " + namespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)delete), validator);
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    public Namespace getNamespace(NamespaceParams params) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        try {
            return this.getNamespace(params.getNamespace(), this.namedRefWithHashOrThrow(params.getRefName(), params.getHashOnRef()).getHash());
        }
        catch (ReferenceNotFoundException e) {
            throw NamespaceApiImpl.refNotFoundException(e);
        }
    }

    private Namespace getNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException, NessieNamespaceNotFoundException {
        Optional<Content> explicitlyCreatedNamespace = this.getExplicitlyCreatedNamespace(namespace, hash);
        if (explicitlyCreatedNamespace.isPresent()) {
            return (Namespace)explicitlyCreatedNamespace.get().unwrap(Namespace.class).orElseThrow(() -> NamespaceApiImpl.namespaceDoesNotExistException(namespace));
        }
        return this.getImplicitlyCreatedNamespace(namespace, hash).orElseThrow(() -> NamespaceApiImpl.namespaceDoesNotExistException(namespace));
    }

    public GetNamespacesResponse getNamespaces(MultipleNamespacesParams params) throws NessieReferenceNotFoundException {
        WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(params.getRefName(), params.getHashOnRef());
        try {
            HashSet explicitNamespaceKeys = new HashSet();
            HashMap implicitNamespaces = new HashMap();
            try (Stream<KeyEntry> stream = this.getNamespacesKeyStream(params.getNamespace(), refWithHash.getHash(), k -> true);){
                stream.forEach(namespaceKeyWithType -> {
                    if (namespaceKeyWithType.getType().equals(Content.Type.NAMESPACE)) {
                        explicitNamespaceKeys.add(namespaceKeyWithType.getKey());
                    } else {
                        Namespace implicitNamespace = NamespaceApiImpl.namespaceFromType(namespaceKeyWithType);
                        if (!implicitNamespace.isEmpty()) {
                            implicitNamespaces.put(implicitNamespace.getElements(), implicitNamespace);
                        }
                    }
                });
            }
            ImmutableGetNamespacesResponse.Builder response = ImmutableGetNamespacesResponse.builder();
            if (!explicitNamespaceKeys.isEmpty()) {
                Map namespaceValues = this.getStore().getValues((Ref)refWithHash.getHash(), explicitNamespaceKeys);
                namespaceValues.values().stream().filter(Namespace.class::isInstance).map(Namespace.class::cast).peek(explicitNamespace -> implicitNamespaces.remove(explicitNamespace.getElements())).forEach(arg_0 -> ((ImmutableGetNamespacesResponse.Builder)response).addNamespaces(arg_0));
            }
            response.addAllNamespaces(implicitNamespaces.values());
            return response.build();
        }
        catch (ReferenceNotFoundException e) {
            throw NamespaceApiImpl.refNotFoundException(e);
        }
    }

    public void updateProperties(NamespaceParams params, NamespaceUpdate namespaceUpdate) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        try {
            WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(params.getRefName(), null);
            Namespace namespace = this.getNamespace(params.getNamespace(), refWithHash.getHash());
            HashMap properties = new HashMap(namespace.getProperties());
            if (null != namespaceUpdate.getPropertyRemovals()) {
                namespaceUpdate.getPropertyRemovals().forEach(properties::remove);
            }
            if (null != namespaceUpdate.getPropertyUpdates()) {
                properties.putAll(namespaceUpdate.getPropertyUpdates());
            }
            ImmutableNamespace updatedNamespace = ImmutableNamespace.copyOf((Namespace)namespace).withProperties(properties);
            Operation.Put put = Operation.Put.of((ContentKey)ContentKey.of((List)updatedNamespace.getElements()), (Content)updatedNamespace);
            this.commit(BranchName.of((String)((NamedRef)refWithHash.getValue()).getName()), "update properties for namespace " + updatedNamespace.name(), TreeApiImpl.toOp((org.projectnessie.model.Operation)put), () -> null);
        }
        catch (ReferenceConflictException | ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }

    @MustBeClosed
    private Stream<KeyEntry> getNamespacesKeyStream(@Nullable Namespace namespace, Hash hash, Predicate<KeyEntry> earlyFilterPredicate) throws ReferenceNotFoundException {
        return this.getStore().getKeys((Ref)hash).filter(earlyFilterPredicate).filter(k -> null == namespace || NamespaceApiImpl.namespaceFromType(k).isSameOrSubElementOf(namespace));
    }

    private static Namespace namespaceFromType(KeyEntry withType) {
        List elements = withType.getKey().getElements();
        if (!Content.Type.NAMESPACE.equals(withType.getType())) {
            elements = elements.subList(0, elements.size() - 1);
        }
        return Namespace.of((List)elements);
    }

    private Optional<Content> getExplicitlyCreatedNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException {
        return Optional.ofNullable(this.getStore().getValue((Ref)hash, Key.of((List)namespace.getElements())));
    }

    private Optional<Namespace> getImplicitlyCreatedNamespace(Namespace namespace, Hash hash) throws ReferenceNotFoundException {
        try (Stream<KeyEntry> stream = this.getNamespacesKeyStream(namespace, hash, k -> true);){
            Optional<Namespace> optional = stream.findAny().map(NamespaceApiImpl::namespaceFromType);
            return optional;
        }
    }

    private static NessieNamespaceAlreadyExistsException namespaceAlreadyExistsException(Namespace namespace) {
        return new NessieNamespaceAlreadyExistsException(String.format("Namespace '%s' already exists", namespace));
    }

    private static NessieNamespaceAlreadyExistsException otherContentAlreadyExistsException(Namespace namespace) {
        return new NessieNamespaceAlreadyExistsException(String.format("Another content object with name '%s' already exists", namespace));
    }

    private static NessieNamespaceNotFoundException namespaceDoesNotExistException(Namespace namespace) {
        return new NessieNamespaceNotFoundException(String.format("Namespace '%s' does not exist", namespace));
    }

    private static NessieNamespaceNotEmptyException namespaceNotEmptyException(Namespace namespace) {
        return new NessieNamespaceNotEmptyException(String.format("Namespace '%s' is not empty", namespace));
    }

    private static NessieReferenceNotFoundException refNotFoundException(ReferenceNotFoundException e) {
        return new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
    }

    private Hash commit(BranchName branch, String commitMsg, Operation contentOperation, Callable<Void> validator) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.getStore().commit(branch, Optional.empty(), (CommitMeta)this.commitMetaUpdate().rewriteSingle((Object)CommitMeta.fromMessage((String)commitMsg)), Collections.singletonList(contentOperation), validator);
    }
}

