/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.api.params.GetReferenceParams;
import org.projectnessie.api.params.ReferencesParams;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceAlreadyExistsException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.BaseMergeTransplant;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableContentKeyDetails;
import org.projectnessie.model.ImmutableEntriesResponse;
import org.projectnessie.model.ImmutableLogEntry;
import org.projectnessie.model.ImmutableLogResponse;
import org.projectnessie.model.ImmutableMergeResponse;
import org.projectnessie.model.ImmutableReferenceMetadata;
import org.projectnessie.model.ImmutableReferencesResponse;
import org.projectnessie.model.ImmutableTag;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Transplant;
import org.projectnessie.model.Validation;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.cel.CELUtil;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.impl.StreamUtil;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class TreeApiImpl
extends BaseApiImpl
implements TreeApi {
    private static final int MAX_COMMIT_LOG_ENTRIES = 250;

    public TreeApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Principal principal) {
        super(config, store, authorizer, principal);
    }

    public ReferencesResponse getAllReferences(ReferencesParams params) {
        Preconditions.checkArgument((params.pageToken() == null ? 1 : 0) != 0, (Object)"Paging not supported");
        ImmutableReferencesResponse.Builder resp = ReferencesResponse.builder();
        boolean fetchAll = FetchOption.isFetchAll((FetchOption)params.fetchOption());
        try (Stream str = this.getStore().getNamedRefs(this.getGetNamedRefsParams(fetchAll));){
            Stream<Reference> unfiltered = str.map(refInfo -> TreeApiImpl.makeReference((ReferenceInfo<CommitMeta>)refInfo, fetchAll));
            Stream<Reference> filtered = TreeApiImpl.filterReferences(unfiltered, params.filter());
            filtered.forEach(arg_0 -> ((ImmutableReferencesResponse.Builder)resp).addReferences(arg_0));
        }
        catch (ReferenceNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not find default branch '%s'.", this.getConfig().getDefaultBranch()));
        }
        return resp.build();
    }

    private GetNamedRefsParams getGetNamedRefsParams(boolean fetchMetadata) {
        return fetchMetadata ? GetNamedRefsParams.builder().baseReference((NamedRef)BranchName.of((String)this.getConfig().getDefaultBranch())).branchRetrieveOptions(GetNamedRefsParams.RetrieveOptions.BASE_REFERENCE_RELATED_AND_COMMIT_META).tagRetrieveOptions(GetNamedRefsParams.RetrieveOptions.COMMIT_META).build() : GetNamedRefsParams.DEFAULT;
    }

    private static Stream<Reference> filterReferences(Stream<Reference> references, String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return references;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.REFERENCES_DECLARATIONS).withTypes(CELUtil.REFERENCES_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return references.filter(reference -> {
            try {
                CommitMeta commit;
                ReferenceMetadata refMeta = reference.getMetadata();
                if (refMeta == null) {
                    refMeta = CELUtil.EMPTY_REFERENCE_METADATA;
                }
                if ((commit = refMeta.getCommitMetaOfHEAD()) == null) {
                    commit = CELUtil.EMPTY_COMMIT_META;
                }
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"ref", (Object)reference, (Object)"refType", (Object)reference.getType().name(), (Object)"commit", (Object)commit, (Object)"refMeta", (Object)refMeta));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Reference getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        try {
            boolean fetchAll = FetchOption.isFetchAll((FetchOption)params.fetchOption());
            return TreeApiImpl.makeReference((ReferenceInfo<CommitMeta>)this.getStore().getNamedRef(params.getRefName(), this.getGetNamedRefsParams(fetchAll)), fetchAll);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public Reference createReference(String sourceRefName, Reference reference) throws NessieNotFoundException, NessieConflictException {
        Validation.validateForbiddenReferenceName((String)reference.getName());
        NamedRef namedReference = RefUtil.toNamedRef(reference);
        if (reference.getType() == Reference.ReferenceType.TAG && reference.getHash() == null) {
            throw new IllegalArgumentException("Tag-creation requires a target named-reference and hash.");
        }
        try {
            Hash hash = this.getStore().create(namedReference, TreeApiImpl.toHash(reference.getHash(), false));
            return RefUtil.toReference(namedReference, hash);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceAlreadyExistsException e) {
            throw new NessieReferenceAlreadyExistsException(e.getMessage(), (Throwable)e);
        }
    }

    public Branch getDefaultBranch() throws NessieNotFoundException {
        Reference r = this.getReferenceByName(GetReferenceParams.builder().refName(this.getConfig().getDefaultBranch()).build());
        if (!(r instanceof Branch)) {
            throw new IllegalStateException("Default branch isn't a branch");
        }
        return (Branch)r;
    }

    public void assignReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.assignReference(RefUtil.toNamedRef(referenceType, referenceName), expectedHash, assignTo);
    }

    public void deleteReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.deleteReference(RefUtil.toNamedRef(referenceType, referenceName), expectedHash);
    }

    public LogResponse getCommitLog(String namedRef, CommitLogParams params) throws NessieNotFoundException {
        WithHash<NamedRef> endRef = this.namedRefWithHashOrThrow(namedRef, null == params.pageToken() ? params.endHash() : params.pageToken());
        return this.getCommitLog(params, endRef);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected LogResponse getCommitLog(CommitLogParams params, WithHash<NamedRef> endRef) throws NessieNotFoundException {
        int max = Math.min(params.maxRecords() != null ? params.maxRecords() : 250, 250);
        boolean fetchAll = FetchOption.isFetchAll((FetchOption)params.fetchOption());
        try (Stream commits = this.getStore().getCommits((Ref)endRef.getHash(), fetchAll);){
            Stream<LogResponse.LogEntry> logEntries = commits.map(commit -> this.commitToLogEntry(fetchAll, (Commit)commit));
            logEntries = StreamSupport.stream(StreamUtil.takeUntilIncl(logEntries.spliterator(), x -> Objects.equals(x.getCommitMeta().getHash(), params.startHash())), false);
            List items = TreeApiImpl.filterCommitLog(logEntries, params.filter()).limit(max + 1).collect(Collectors.toList());
            if (items.size() == max + 1) {
                ImmutableLogResponse immutableLogResponse2 = LogResponse.builder().addAllLogEntries(items.subList(0, max)).isHasMore(true).token(((LogResponse.LogEntry)items.get(max)).getCommitMeta().getHash()).build();
                return immutableLogResponse2;
            }
            ImmutableLogResponse immutableLogResponse = LogResponse.builder().addAllLogEntries(items).build();
            return immutableLogResponse;
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    private ImmutableLogEntry commitToLogEntry(boolean fetchAll, Commit commit) {
        CommitMeta commitMetaWithHash = TreeApiImpl.enhanceCommitMeta(commit.getHash(), commit.getCommitMeta(), commit.getAdditionalParents());
        ImmutableLogEntry.Builder logEntry = LogResponse.LogEntry.builder();
        logEntry.commitMeta(commitMetaWithHash);
        if (commit.getParentHash() != null) {
            logEntry.parentCommitHash(commit.getParentHash().asString());
        }
        if (fetchAll && commit.getOperations() != null) {
            commit.getOperations().forEach(op -> {
                ContentKey key = TreeApiImpl.fromKey(op.getKey());
                if (op instanceof Put) {
                    Content content = ((Put)op).getValue();
                    logEntry.addOperations((Operation)Operation.Put.of((ContentKey)key, (Content)content));
                }
                if (op instanceof Delete) {
                    logEntry.addOperations((Operation)Operation.Delete.of((ContentKey)key));
                }
            });
        }
        return logEntry.build();
    }

    private static CommitMeta enhanceCommitMeta(Hash hash, CommitMeta commitMeta, List<Hash> additionalParents) {
        ImmutableCommitMeta.Builder updatedCommitMeta = commitMeta.toBuilder().hash(hash.asString());
        if (additionalParents != null && additionalParents.size() == 1) {
            updatedCommitMeta.putProperties("_merge_parent", additionalParents.get(0).asString());
        }
        return updatedCommitMeta.build();
    }

    private static Stream<LogResponse.LogEntry> filterCommitLog(Stream<LogResponse.LogEntry> logEntries, String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return logEntries;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.COMMIT_LOG_DECLARATIONS).withTypes(CELUtil.COMMIT_LOG_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return logEntries.filter(logEntry -> {
            try {
                List operations = logEntry.getOperations();
                if (operations == null) {
                    operations = Collections.emptyList();
                }
                List operationsForCel = operations.stream().map(CELUtil::forCel).collect(Collectors.toList());
                return (Boolean)script.execute(Boolean.class, (Map)ImmutableMap.of((Object)"commit", (Object)logEntry.getCommitMeta(), (Object)"operations", operationsForCel));
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public MergeResponse transplantCommitsIntoBranch(String branchName, String expectedHash, String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        try {
            List transplants;
            try (Stream<Hash> s = transplant.getHashesToTransplant().stream().map(Hash::of);){
                transplants = s.collect(Collectors.toList());
            }
            MergeResult result = this.getStore().transplant(BranchName.of((String)branchName), TreeApiImpl.toHash(expectedHash, true), transplants, this.commitMetaUpdate(), Boolean.TRUE.equals(transplant.keepIndividualCommits()), TreeApiImpl.keyMergeTypes((BaseMergeTransplant)transplant), TreeApiImpl.defaultMergeType((BaseMergeTransplant)transplant), Boolean.TRUE.equals(transplant.isDryRun()), Boolean.TRUE.equals(transplant.isFetchAdditionalInfo()));
            return this.createResponse((BaseMergeTransplant)transplant, (MergeResult<Commit>)result);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (MergeConflictException e) {
            if (Boolean.TRUE.equals(transplant.isReturnConflictAsResult())) {
                MergeResult mr = e.getMergeResult();
                return this.createResponse((BaseMergeTransplant)transplant, (MergeResult<Commit>)mr);
            }
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    public MergeResponse mergeRefIntoBranch(String branchName, String expectedHash, Merge merge) throws NessieNotFoundException, NessieConflictException {
        try {
            MergeResult result = this.getStore().merge(this.toHash(merge.getFromRefName(), merge.getFromHash()), BranchName.of((String)branchName), TreeApiImpl.toHash(expectedHash, true), this.commitMetaUpdate(), Boolean.TRUE.equals(merge.keepIndividualCommits()), TreeApiImpl.keyMergeTypes((BaseMergeTransplant)merge), TreeApiImpl.defaultMergeType((BaseMergeTransplant)merge), Boolean.TRUE.equals(merge.isDryRun()), Boolean.TRUE.equals(merge.isFetchAdditionalInfo()));
            return this.createResponse((BaseMergeTransplant)merge, (MergeResult<Commit>)result);
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (MergeConflictException e) {
            if (Boolean.TRUE.equals(merge.isReturnConflictAsResult())) {
                MergeResult mr = e.getMergeResult();
                return this.createResponse((BaseMergeTransplant)merge, (MergeResult<Commit>)mr);
            }
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    private MergeResponse createResponse(BaseMergeTransplant mergeTransplant, MergeResult<Commit> result) {
        Function<Hash, String> hashToString = h -> h != null ? h.asString() : null;
        ImmutableMergeResponse.Builder response = ImmutableMergeResponse.builder().targetBranch(result.getTargetBranch().getName()).resultantTargetHash(hashToString.apply(result.getResultantTargetHash())).effectiveTargetHash(hashToString.apply(result.getEffectiveTargetHash())).expectedHash(hashToString.apply(result.getExpectedHash())).commonAncestor(hashToString.apply(result.getCommonAncestor())).wasApplied(result.wasApplied()).wasSuccessful(result.wasSuccessful());
        BiConsumer<List, Consumer> convertCommits = (src, dest) -> {
            if (src == null) {
                return;
            }
            src.stream().map(c -> this.commitToLogEntry(Boolean.TRUE.equals(mergeTransplant.isFetchAdditionalInfo()), (Commit)c)).forEach((Consumer<ImmutableLogEntry>)dest);
        };
        convertCommits.accept(result.getSourceCommits(), arg_0 -> ((ImmutableMergeResponse.Builder)response).addSourceCommits(arg_0));
        convertCommits.accept(result.getTargetCommits(), arg_0 -> ((ImmutableMergeResponse.Builder)response).addTargetCommits(arg_0));
        BiConsumer<List, Consumer> convertCommitIds = (src, dest) -> {
            if (src == null) {
                return;
            }
            src.stream().map(hashToString).forEach(dest);
        };
        result.getDetails().forEach((key, details) -> {
            ImmutableContentKeyDetails.Builder keyDetails = ImmutableContentKeyDetails.builder().key(ContentKey.of((List)key.getElements())).conflictType(MergeResponse.ContentKeyConflict.valueOf((String)details.getConflictType().name())).mergeBehavior(BaseMergeTransplant.MergeBehavior.valueOf((String)details.getMergeType().name()));
            convertCommitIds.accept(details.getSourceCommits(), arg_0 -> ((ImmutableContentKeyDetails.Builder)keyDetails).addSourceCommits(arg_0));
            convertCommitIds.accept(details.getTargetCommits(), arg_0 -> ((ImmutableContentKeyDetails.Builder)keyDetails).addTargetCommits(arg_0));
            response.addDetails((MergeResponse.ContentKeyDetails)keyDetails.build());
        });
        return response.build();
    }

    private static Map<Key, MergeType> keyMergeTypes(BaseMergeTransplant params) {
        return params.getKeyMergeModes() != null ? params.getKeyMergeModes().stream().collect(Collectors.toMap(e -> TreeApiImpl.toKey(e.getKey()), e -> MergeType.valueOf((String)e.getMergeBehavior().name()))) : Collections.emptyMap();
    }

    private static MergeType defaultMergeType(BaseMergeTransplant params) {
        return params.getDefaultKeyMergeMode() != null ? MergeType.valueOf((String)params.getDefaultKeyMergeMode().name()) : MergeType.NORMAL;
    }

    public EntriesResponse getEntries(String namedRef, EntriesParams params) throws NessieNotFoundException {
        Preconditions.checkArgument((params.pageToken() == null ? 1 : 0) != 0, (Object)"Paging not supported");
        WithHash<NamedRef> refWithHash = this.namedRefWithHashOrThrow(namedRef, params.hashOnRef());
        try {
            ImmutableEntriesResponse.Builder response = EntriesResponse.builder();
            try (Stream entryStream = this.getStore().getKeys((Ref)refWithHash.getHash());){
                Stream<EntriesResponse.Entry> entriesStream = this.filterEntries(refWithHash, entryStream, params.filter()).map(key -> EntriesResponse.Entry.builder().name(TreeApiImpl.fromKey(key.getKey())).type(key.getType()).build());
                if (params.namespaceDepth() != null && params.namespaceDepth() > 0) {
                    entriesStream = entriesStream.filter(e -> e.getName().getElements().size() >= params.namespaceDepth()).map(e -> TreeApiImpl.truncate(e, params.namespaceDepth())).distinct();
                }
                entriesStream.forEach(arg_0 -> ((ImmutableEntriesResponse.Builder)response).addEntries(arg_0));
            }
            return response.build();
        }
        catch (ReferenceNotFoundException e2) {
            throw new NessieReferenceNotFoundException(e2.getMessage(), (Throwable)e2);
        }
    }

    private static EntriesResponse.Entry truncate(EntriesResponse.Entry entry, Integer depth) {
        if (depth == null || depth < 1) {
            return entry;
        }
        Content.Type type = entry.getName().getElements().size() > depth ? Content.Type.NAMESPACE : entry.getType();
        ContentKey key = ContentKey.of(entry.getName().getElements().subList(0, depth));
        return EntriesResponse.Entry.builder().type(type).name(key).build();
    }

    protected Stream<KeyEntry> filterEntries(WithHash<NamedRef> refWithHash, Stream<KeyEntry> entries, String filter) {
        Script script;
        if (Strings.isNullOrEmpty((String)filter)) {
            return entries;
        }
        try {
            script = CELUtil.SCRIPT_HOST.buildScript(filter).withContainer("org.projectnessie.model").withDeclarations(CELUtil.ENTRIES_DECLARATIONS).withTypes(CELUtil.ENTRIES_TYPES).build();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException(e);
        }
        return entries.filter(entry -> {
            ImmutableMap arguments = ImmutableMap.of((Object)"entry", (Object)CELUtil.forCel(entry));
            try {
                return (Boolean)script.execute(Boolean.class, (Map)arguments);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Branch commitMultipleOperations(String branch, String expectedHash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        List ops = (List)operations.getOperations().stream().map(TreeApiImpl::toOp).collect(ImmutableList.toImmutableList());
        CommitMeta commitMeta = operations.getCommitMeta();
        if (commitMeta.getCommitter() != null) {
            throw new IllegalArgumentException("Cannot set the committer on the client side. It is set by the server.");
        }
        try {
            Hash newHash = this.getStore().commit(BranchName.of((String)Optional.ofNullable(branch).orElse(this.getConfig().getDefaultBranch())), Optional.ofNullable(expectedHash).map(Hash::of), (CommitMeta)this.commitMetaUpdate().rewriteSingle((Object)commitMeta), ops);
            return Branch.of((String)branch, (String)newHash.asString());
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    private Hash toHash(String referenceName, String hashOnReference) throws ReferenceNotFoundException {
        if ("DETACHED".equals(referenceName)) {
            return Hash.of((String)hashOnReference);
        }
        if (hashOnReference == null) {
            return this.getStore().getNamedRef(referenceName, GetNamedRefsParams.DEFAULT).getHash();
        }
        return TreeApiImpl.toHash(hashOnReference, true).orElseThrow(() -> new IllegalStateException("Required hash is missing"));
    }

    private static Optional<Hash> toHash(String hash, boolean required) {
        if (hash == null || hash.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException("Must provide expected hash value for operation.");
            }
            return Optional.empty();
        }
        return Optional.of(Hash.of((String)hash));
    }

    protected void deleteReference(NamedRef ref, String expectedHash) throws NessieConflictException, NessieNotFoundException {
        try {
            this.getStore().delete(ref, TreeApiImpl.toHash(expectedHash, true));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    protected void assignReference(NamedRef ref, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        try {
            ReferenceInfo resolved = this.getStore().getNamedRef(ref.getName(), GetNamedRefsParams.DEFAULT);
            this.getStore().assign(resolved.getNamedRef(), TreeApiImpl.toHash(expectedHash, true), this.toHash(assignTo.getName(), assignTo.getHash()));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ReferenceConflictException e) {
            throw new NessieReferenceConflictException(e.getMessage(), (Throwable)e);
        }
    }

    protected static ContentKey fromKey(Key key) {
        return ContentKey.of((List)key.getElements());
    }

    protected static Key toKey(ContentKey key) {
        return Key.of((List)key.getElements());
    }

    private static Reference makeReference(ReferenceInfo<CommitMeta> refWithHash, boolean fetchMetadata) {
        NamedRef ref = refWithHash.getNamedRef();
        if (ref instanceof TagName) {
            ImmutableTag.Builder builder = ImmutableTag.builder().name(ref.getName()).hash(refWithHash.getHash().asString());
            if (fetchMetadata) {
                builder.metadata(TreeApiImpl.extractReferenceMetadata(refWithHash));
            }
            return builder.build();
        }
        if (ref instanceof BranchName) {
            ImmutableBranch.Builder builder = ImmutableBranch.builder().name(ref.getName()).hash(refWithHash.getHash().asString());
            if (fetchMetadata) {
                builder.metadata(TreeApiImpl.extractReferenceMetadata(refWithHash));
            }
            return builder.build();
        }
        throw new UnsupportedOperationException("only converting tags or branches");
    }

    @Nullable
    private static ReferenceMetadata extractReferenceMetadata(ReferenceInfo<CommitMeta> refWithHash) {
        ImmutableReferenceMetadata.Builder builder = ImmutableReferenceMetadata.builder();
        boolean found = false;
        if (null != refWithHash.getAheadBehind()) {
            found = true;
            builder.numCommitsAhead(Integer.valueOf(refWithHash.getAheadBehind().getAhead()));
            builder.numCommitsBehind(Integer.valueOf(refWithHash.getAheadBehind().getBehind()));
        }
        if (null != refWithHash.getHeadCommitMeta()) {
            found = true;
            builder.commitMetaOfHEAD(TreeApiImpl.enhanceCommitMeta(refWithHash.getHash(), (CommitMeta)refWithHash.getHeadCommitMeta(), null));
        }
        if (0L != refWithHash.getCommitSeq()) {
            found = true;
            builder.numTotalCommits(Long.valueOf(refWithHash.getCommitSeq()));
        }
        if (null != refWithHash.getCommonAncestor()) {
            found = true;
            builder.commonAncestorHash(refWithHash.getCommonAncestor().asString());
        }
        if (!found) {
            return null;
        }
        return builder.build();
    }

    protected static org.projectnessie.versioned.Operation toOp(Operation o) {
        Key key = TreeApiImpl.toKey(o.getKey());
        if (o instanceof Operation.Delete) {
            return Delete.of((Key)key);
        }
        if (o instanceof Operation.Put) {
            Operation.Put put = (Operation.Put)o;
            return put.getExpectedContent() != null ? Put.of((Key)key, (Content)put.getContent(), (Content)put.getExpectedContent()) : Put.of((Key)key, (Content)put.getContent());
        }
        if (o instanceof Operation.Unchanged) {
            return Unchanged.of((Key)key);
        }
        throw new IllegalStateException("Unknown operation " + o);
    }
}

