/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.authz;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.services.authz.ImmutableCheck;
import org.projectnessie.versioned.NamedRef;

@Value.Immutable
public interface Check {
    public CheckType type();

    @Nullable
    public NamedRef ref();

    @Nullable
    public ContentKey key();

    @Nullable
    public String contentId();

    @Nullable
    public Content.Type contentType();

    public static ImmutableCheck.Builder builder(CheckType type) {
        return ImmutableCheck.builder().type(type);
    }

    public static enum CheckType {
        VIEW_REFERENCE(true, false),
        CREATE_REFERENCE(true, false),
        ASSIGN_REFERENCE_TO_HASH(true, false),
        DELETE_REFERENCE(true, false),
        READ_ENTRIES(true, false),
        READ_CONTENT_KEY(true, true),
        LIST_COMMIT_LOG(true, false),
        COMMIT_CHANGE_AGAINST_REFERENCE(true, false),
        READ_ENTITY_VALUE(true, true),
        UPDATE_ENTITY(true, true),
        DELETE_ENTITY(true, true),
        VIEW_REFLOG(false, false);

        private final boolean ref;
        private final boolean content;

        private CheckType(boolean ref, boolean content) {
            this.ref = ref;
            this.content = content;
        }

        public boolean isRef() {
            return this.ref;
        }

        public boolean isContent() {
            return this.content;
        }
    }
}

