/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.ImmutableLogEntry;
import org.projectnessie.model.ImmutableLogResponse;
import org.projectnessie.model.ImmutableReferencesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.authz.Check;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class TreeApiImplWithAuthorization
extends TreeApiImpl {
    public TreeApiImplWithAuthorization(ServerConfig config, VersionStore store, Authorizer authorizer, Principal principal) {
        super(config, store, authorizer, principal);
    }

    @Override
    public ReferencesResponse getAllReferences(FetchOption fetchOption, String filter) {
        ImmutableReferencesResponse.Builder resp = ReferencesResponse.builder();
        BatchAccessChecker check = this.startAccessCheck();
        List refs = super.getAllReferences(fetchOption, filter).getReferences().stream().peek(ref -> check.canViewReference(RefUtil.toNamedRef(ref))).collect(Collectors.toList());
        Set notAllowed = check.check().keySet().stream().map(Check::ref).filter(Objects::nonNull).collect(Collectors.toSet());
        refs.stream().filter(ref -> !notAllowed.contains(RefUtil.toNamedRef(ref))).forEach(arg_0 -> ((ImmutableReferencesResponse.Builder)resp).addReferences(arg_0));
        return resp.build();
    }

    @Override
    public Reference getReferenceByName(String refName, FetchOption fetchOption) throws NessieNotFoundException {
        Reference ref = super.getReferenceByName(refName, fetchOption);
        this.startAccessCheck().canViewReference(RefUtil.toNamedRef(ref)).checkAndThrow();
        return ref;
    }

    @Override
    public Reference createReference(String refName, Reference.ReferenceType type, String targetHash, String sourceRefName) throws NessieNotFoundException, NessieConflictException {
        BatchAccessChecker check;
        block2: {
            check = this.startAccessCheck().canCreateReference(RefUtil.toNamedRef(type, refName));
            try {
                check.canViewReference((NamedRef)this.namedRefWithHashOrThrow(sourceRefName, targetHash).getValue());
            }
            catch (NessieNotFoundException e) {
                if (Reference.ReferenceType.BRANCH.equals((Object)type) && refName.equals(this.getConfig().getDefaultBranch()) && (null == targetHash || this.getStore().noAncestorHash().asString().equals(targetHash))) break block2;
                throw e;
            }
        }
        check.checkAndThrow();
        return super.createReference(refName, type, targetHash, sourceRefName);
    }

    @Override
    protected Reference assignReference(NamedRef ref, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.startAccessCheck().canViewReference((NamedRef)this.namedRefWithHashOrThrow(assignTo.getName(), assignTo.getHash()).getValue()).canAssignRefToHash(ref).checkAndThrow();
        return super.assignReference(ref, expectedHash, assignTo);
    }

    @Override
    protected void deleteReference(NamedRef ref, String expectedHash) throws NessieConflictException, NessieNotFoundException {
        if (ref instanceof BranchName && this.getConfig().getDefaultBranch().equals(ref.getName())) {
            throw new IllegalArgumentException("Default branch '" + ref.getName() + "' cannot be deleted.");
        }
        this.startAccessCheck().canDeleteReference(ref).checkAndThrow();
        super.deleteReference(ref, expectedHash);
    }

    @Override
    protected Stream<KeyEntry> filterEntries(WithHash<NamedRef> refWithHash, Stream<KeyEntry> entries, String filter) {
        this.startAccessCheck().canReadEntries((NamedRef)refWithHash.getValue()).checkAndThrow();
        List<KeyEntry> entriesList = super.filterEntries(refWithHash, entries, filter).collect(Collectors.toList());
        BatchAccessChecker responseCheck = this.startAccessCheck();
        entriesList.forEach(e -> responseCheck.canReadContentKey((NamedRef)refWithHash.getValue(), TreeApiImplWithAuthorization.fromKey(e.getKey()), e.getContentId()));
        Set notAllowedContentIds = responseCheck.check().keySet().stream().map(Check::contentId).collect(Collectors.toSet());
        return entriesList.stream().filter(entry -> !notAllowedContentIds.contains(entry.getContentId()));
    }

    @Override
    protected LogResponse getCommitLog(Integer maxRecords, FetchOption fetchOption, String filter, WithHash<NamedRef> endRef, String startHash) throws NessieNotFoundException {
        NamedRef ref = (NamedRef)endRef.getValue();
        this.startAccessCheck().canListCommitLog(ref).checkAndThrow();
        LogResponse logResponse = super.getCommitLog(maxRecords, fetchOption, filter, endRef, startHash);
        Stream allOperations = logResponse.getLogEntries().stream().map(LogResponse.LogEntry::getOperations).filter(Objects::nonNull).flatMap(Collection::stream);
        BatchAccessChecker responseCheck = this.startAccessCheck();
        allOperations.forEach(op -> {
            if (op instanceof Operation.Put) {
                Operation.Put put = (Operation.Put)op;
                responseCheck.canReadContentKey(ref, put.getKey(), put.getContent().getId());
            } else if (op instanceof Operation.Delete) {
                Operation.Delete delete = (Operation.Delete)op;
                responseCheck.canReadContentKey(ref, delete.getKey(), null);
            }
        });
        Set notAllowed = responseCheck.check().keySet().stream().map(Check::key).collect(Collectors.toSet());
        ImmutableLogResponse.Builder newLogResponse = LogResponse.builder().isHasMore(logResponse.isHasMore()).token(logResponse.getToken());
        logResponse.getLogEntries().stream().map(e -> {
            ImmutableLogEntry.Builder newLogEntry = LogResponse.LogEntry.builder().commitMeta(e.getCommitMeta()).parentCommitHash(e.getParentCommitHash()).additionalParents((Iterable)e.getAdditionalParents());
            if (e.getOperations() != null) {
                e.getOperations().stream().filter(op -> !notAllowed.contains(op.getKey())).forEach(arg_0 -> ((ImmutableLogEntry.Builder)newLogEntry).addOperations(arg_0));
            }
            return newLogEntry.build();
        }).forEach(arg_0 -> ((ImmutableLogResponse.Builder)newLogResponse).addLogEntries(arg_0));
        return newLogResponse.build();
    }

    @Override
    public MergeResponse transplantCommitsIntoBranch(String branchName, String expectedHash, String message, List<String> hashesToTransplant, String fromRefName, Boolean keepIndividualCommits, Collection<MergeKeyBehavior> keyMergeTypes, MergeBehavior defaultMergeType, Boolean dryRun, Boolean fetchAdditionalInfo, Boolean returnConflictAsResult) throws NessieNotFoundException, NessieConflictException {
        if (hashesToTransplant.isEmpty()) {
            throw new IllegalArgumentException("No hashes given to transplant.");
        }
        this.startAccessCheck().canViewReference((NamedRef)this.namedRefWithHashOrThrow(fromRefName, hashesToTransplant.get(hashesToTransplant.size() - 1)).getValue()).canCommitChangeAgainstReference((NamedRef)BranchName.of((String)branchName)).checkAndThrow();
        return super.transplantCommitsIntoBranch(branchName, expectedHash, message, hashesToTransplant, fromRefName, keepIndividualCommits, keyMergeTypes, defaultMergeType, dryRun, fetchAdditionalInfo, returnConflictAsResult);
    }

    @Override
    public MergeResponse mergeRefIntoBranch(String branchName, String expectedHash, String fromRefName, String fromHash, Boolean keepIndividualCommits, @Nullable String message, Collection<MergeKeyBehavior> keyMergeTypes, MergeBehavior defaultMergeType, Boolean dryRun, Boolean fetchAdditionalInfo, Boolean returnConflictAsResult) throws NessieNotFoundException, NessieConflictException {
        this.startAccessCheck().canViewReference((NamedRef)this.namedRefWithHashOrThrow(fromRefName, fromHash).getValue()).canCommitChangeAgainstReference((NamedRef)BranchName.of((String)branchName)).checkAndThrow();
        return super.mergeRefIntoBranch(branchName, expectedHash, fromRefName, fromHash, keepIndividualCommits, message, keyMergeTypes, defaultMergeType, dryRun, fetchAdditionalInfo, returnConflictAsResult);
    }

    @Override
    public Branch commitMultipleOperations(String branch, String expectedHash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        BranchName branchName = BranchName.of((String)branch);
        BatchAccessChecker check = this.startAccessCheck().canCommitChangeAgainstReference((NamedRef)branchName);
        operations.getOperations().forEach(op -> {
            if (op instanceof Operation.Delete) {
                check.canDeleteEntity((NamedRef)branchName, op.getKey(), null);
            } else if (op instanceof Operation.Put) {
                Operation.Put putOp = (Operation.Put)op;
                check.canUpdateEntity((NamedRef)branchName, op.getKey(), putOp.getContent().getId(), putOp.getContent().getType());
            }
        });
        check.checkAndThrow();
        return super.commitMultipleOperations(branch, expectedHash, operations);
    }
}

