/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import java.util.List;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ContentApiImpl;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class ContentApiImplWithAuthorization
extends ContentApiImpl {
    public ContentApiImplWithAuthorization(ServerConfig config, VersionStore store, Authorizer authorizer, Principal principal) {
        super(config, store, authorizer, principal);
    }

    @Override
    public Content getContent(ContentKey key, String namedRef, String hashOnRef) throws NessieNotFoundException {
        NamedRef ref = (NamedRef)this.namedRefWithHashOrThrow(namedRef, hashOnRef).getValue();
        this.startAccessCheck().canReadEntityValue(ref, key, null).checkAndThrow();
        return super.getContent(key, namedRef, hashOnRef);
    }

    @Override
    public GetMultipleContentsResponse getMultipleContents(String namedRef, String hashOnRef, List<ContentKey> externalKeys) throws NessieNotFoundException {
        WithHash<NamedRef> ref = this.namedRefWithHashOrThrow(namedRef, hashOnRef);
        BatchAccessChecker check = this.startAccessCheck();
        externalKeys.forEach(k -> check.canReadEntityValue((NamedRef)ref.getValue(), (ContentKey)k, null));
        check.checkAndThrow();
        return super.getMultipleContents(namedRef, hashOnRef, externalKeys);
    }
}

