/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.impl;

import java.security.Principal;
import java.util.List;
import java.util.stream.Stream;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.ImmutableDiffResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.BaseApiImpl;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;

public class DiffApiImpl
extends BaseApiImpl
implements DiffService {
    public DiffApiImpl(ServerConfig config, VersionStore store, Authorizer authorizer, Principal principal) {
        super(config, store, authorizer, principal);
    }

    @Override
    public DiffResponse getDiff(String fromRef, String fromHash, String toRef, String toHash) throws NessieNotFoundException {
        WithHash<NamedRef> from = this.namedRefWithHashOrThrow(fromRef, fromHash);
        WithHash<NamedRef> to = this.namedRefWithHashOrThrow(toRef, toHash);
        return this.getDiff(from.getHash(), to.getHash());
    }

    protected DiffResponse getDiff(Hash from, Hash to) throws NessieNotFoundException {
        ImmutableDiffResponse.Builder builder = ImmutableDiffResponse.builder();
        try (Stream diffs = this.getStore().getDiffs((Ref)from, (Ref)to);){
            diffs.map(diff -> DiffResponse.DiffEntry.diffEntry((ContentKey)ContentKey.of((List)diff.getKey().getElements()), (Content)diff.getFromValue().orElse(null), (Content)diff.getToValue().orElse(null))).forEach(arg_0 -> ((ImmutableDiffResponse.Builder)builder).addDiffs(arg_0));
        }
        catch (ReferenceNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        return builder.build();
    }
}

