/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.Unchanged;

class Commit<ValueT, MetadataT> {
    private static final HashFunction COMMIT_HASH_FUNCTION = Hashing.sha256();
    public static final Hash NO_ANCESTOR = Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])COMMIT_HASH_FUNCTION.newHasher().putString((CharSequence)"empty", StandardCharsets.UTF_8).hash().asBytes()));
    private final Hash hash;
    private final Hash ancestor;
    private final MetadataT metadata;
    private final List<Operation<ValueT>> operations;

    public Commit(Hash hash, Hash ancestor, MetadataT metadata, List<Operation<ValueT>> operations) {
        this.hash = Objects.requireNonNull(hash);
        this.ancestor = Objects.requireNonNull(ancestor);
        this.metadata = Objects.requireNonNull(metadata);
        this.operations = ImmutableList.copyOf((Collection)Objects.requireNonNull(operations));
    }

    public static <ValueT, MetadataT> Commit<ValueT, MetadataT> of(Serializer<ValueT> valueSerializer, Serializer<MetadataT> metadataSerializer, Hash ancestor, MetadataT metadata, List<Operation<ValueT>> operations) {
        Hasher hasher = COMMIT_HASH_FUNCTION.newHasher();
        hasher.putString((CharSequence)"ancestor", StandardCharsets.UTF_8);
        Commit.hash(hasher, ancestor.asBytes());
        hasher.putString((CharSequence)"metadata", StandardCharsets.UTF_8);
        Commit.hash(hasher, metadataSerializer.toBytes(metadata));
        for (Operation<ValueT> operation : operations) {
            if (operation instanceof Put) {
                Put put = (Put)operation;
                hasher.putString((CharSequence)"put", StandardCharsets.UTF_8);
                Commit.hash(hasher, put.getKey());
                Commit.hash(hasher, valueSerializer.toBytes(put.getValue()));
                continue;
            }
            if (operation instanceof Delete) {
                Delete delete = (Delete)operation;
                hasher.putString((CharSequence)"delete", StandardCharsets.UTF_8);
                Commit.hash(hasher, delete.getKey());
                continue;
            }
            if (operation instanceof Unchanged) {
                Unchanged unchanged = (Unchanged)operation;
                Commit.hash(hasher, unchanged.getKey());
                unchanged.getKey().getElements().forEach(e -> hasher.putString((CharSequence)e, StandardCharsets.UTF_8));
                continue;
            }
            throw new IllegalArgumentException("Unknown operation type for operation " + operation);
        }
        Hash commitHash = Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])hasher.hash().asBytes()));
        return new Commit<ValueT, MetadataT>(commitHash, ancestor, metadata, operations);
    }

    private static final Hasher hash(Hasher hasher, ByteString bytes) {
        bytes.asReadOnlyByteBufferList().forEach(arg_0 -> ((Hasher)hasher).putBytes(arg_0));
        return hasher;
    }

    private static final Hasher hash(Hasher hasher, Key key) {
        key.getElements().forEach(e -> hasher.putString((CharSequence)e.toLowerCase(Locale.ROOT), StandardCharsets.UTF_8));
        return hasher;
    }

    public Hash getHash() {
        return this.hash;
    }

    public Hash getAncestor() {
        return this.ancestor;
    }

    public MetadataT getMetadata() {
        return this.metadata;
    }

    public List<Operation<ValueT>> getOperations() {
        return this.operations;
    }

    public String toString() {
        return "Commit [hash=" + this.hash + ", ancestor=" + this.ancestor + ", metadata=" + this.metadata + ", operations=" + this.operations + "]";
    }
}

