/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.memory;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.memory.Commit;

final class CommitsIterator<ValueT, MetadataT>
implements Iterator<WithHash<Commit<ValueT, MetadataT>>> {
    private final Function<Hash, Commit<ValueT, MetadataT>> commitAccessor;
    private WithHash<Commit<ValueT, MetadataT>> current;
    private Hash ancestor = Commit.NO_ANCESTOR;

    CommitsIterator(Function<Hash, Commit<ValueT, MetadataT>> commitAccessor, Hash initialHash) {
        this.commitAccessor = commitAccessor;
        this.ancestor = initialHash;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (this.ancestor.equals((Object)Commit.NO_ANCESTOR)) {
            return false;
        }
        Commit<ValueT, MetadataT> commit = this.commitAccessor.apply(this.ancestor);
        if (commit == null) {
            throw new IllegalStateException("Missing entry for commit " + this.ancestor.asString());
        }
        this.current = WithHash.of((Hash)this.ancestor, commit);
        this.ancestor = ((Commit)this.current.getValue()).getAncestor();
        return true;
    }

    @Override
    public WithHash<Commit<ValueT, MetadataT>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        WithHash<Commit<ValueT, MetadataT>> result = this.current;
        this.current = null;
        return result;
    }
}

