/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyListEntry", generator="Immutables")
@Immutable
public final class ImmutableKeyListEntry
implements KeyListEntry {
    private final Key key;
    private final ContentId contentId;
    private final byte payload;
    @Nullable
    private final Hash commitId;
    private transient int hashCode;

    private ImmutableKeyListEntry(Key key, ContentId contentId, byte payload, @Nullable Hash commitId) {
        this.key = key;
        this.contentId = contentId;
        this.payload = payload;
        this.commitId = commitId;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public ContentId getContentId() {
        return this.contentId;
    }

    @Override
    public byte getPayload() {
        return this.payload;
    }

    @Override
    @Nullable
    public Hash getCommitId() {
        return this.commitId;
    }

    public final ImmutableKeyListEntry withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableKeyListEntry(newValue, this.contentId, this.payload, this.commitId);
    }

    public final ImmutableKeyListEntry withContentId(ContentId value) {
        if (this.contentId == value) {
            return this;
        }
        ContentId newValue = Objects.requireNonNull(value, "contentId");
        return new ImmutableKeyListEntry(this.key, newValue, this.payload, this.commitId);
    }

    public final ImmutableKeyListEntry withPayload(byte value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableKeyListEntry(this.key, this.contentId, value, this.commitId);
    }

    public final ImmutableKeyListEntry withCommitId(@Nullable Hash value) {
        if (this.commitId == value) {
            return this;
        }
        return new ImmutableKeyListEntry(this.key, this.contentId, this.payload, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyListEntry && this.equalTo(0, (ImmutableKeyListEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyListEntry another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.key.equals((Object)another.key) && this.contentId.equals(another.contentId) && this.payload == another.payload && Objects.equals(this.commitId, another.commitId);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.contentId.hashCode();
        h += (h << 5) + Bytes.hashCode((byte)this.payload);
        h += (h << 5) + Objects.hashCode(this.commitId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyListEntry").omitNullValues().add("key", (Object)this.key).add("contentId", (Object)this.contentId).add("payload", (int)this.payload).add("commitId", (Object)this.commitId).toString();
    }

    public static ImmutableKeyListEntry copyOf(KeyListEntry instance) {
        if (instance instanceof ImmutableKeyListEntry) {
            return (ImmutableKeyListEntry)instance;
        }
        return ImmutableKeyListEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyListEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT_ID = 2L;
        private static final long INIT_BIT_PAYLOAD = 4L;
        private long initBits = 7L;
        @Nullable
        private Key key;
        @Nullable
        private ContentId contentId;
        private byte payload;
        @Nullable
        private Hash commitId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyListEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.contentId(instance.getContentId());
            this.payload(instance.getPayload());
            Hash commitIdValue = instance.getCommitId();
            if (commitIdValue != null) {
                this.commitId(commitIdValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(ContentId contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(byte payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitId(@Nullable Hash commitId) {
            this.commitId = commitId;
            return this;
        }

        public ImmutableKeyListEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyListEntry(this.key, this.contentId, this.payload, this.commitId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("payload");
            }
            return "Cannot build KeyListEntry, some of required attributes are not set " + attributes;
        }
    }
}

