/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.annotations.Beta;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.agrona.collections.Object2ObjectHashMap;
import org.agrona.collections.ObjectHashSet;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.ReferencedAndUnreferencedHeads;

@Beta
public final class ReferencesUtil {
    private final DatabaseAdapter databaseAdapter;

    private ReferencesUtil(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    public static ReferencesUtil forDatabaseAdapter(DatabaseAdapter databaseAdapter) {
        return new ReferencesUtil(databaseAdapter);
    }

    private static <K, V> Map<K, V> newOpenAddressingHashMap() {
        return new Object2ObjectHashMap(16, 0.65f, false);
    }

    private static <T> Set<T> newOpenAddressingHashSet(int initialCapacity) {
        return new ObjectHashSet(initialCapacity, 0.65f, false);
    }

    private static <T> Set<T> newOpenAddressingHashSet(Set<T> source) {
        ObjectHashSet copy = new ObjectHashSet(source.size(), 0.65f, false);
        if (source instanceof ObjectHashSet) {
            copy.addAll((ObjectHashSet)source);
        } else {
            copy.addAll(source);
        }
        return copy;
    }

    private static <T> Set<T> newOpenAddressingHashSet() {
        return ReferencesUtil.newOpenAddressingHashSet(8);
    }

    public HeadsAndForkPoints identifyAllHeadsAndForkPoints(int expectedCommitCount, Consumer<CommitLogEntry> commitHandler) {
        Set parents = ReferencesUtil.newOpenAddressingHashSet(expectedCommitCount);
        Set<Hash> heads = ReferencesUtil.newOpenAddressingHashSet();
        Set<Hash> forkPoints = ReferencesUtil.newOpenAddressingHashSet();
        long scanStartedAtInMicros = this.databaseAdapter.getConfig().currentTimeInMicros();
        try (Stream<CommitLogEntry> scan = this.databaseAdapter.scanAllCommitLogEntries();){
            scan.peek(commitHandler).forEach(entry -> {
                Hash parent = entry.getParents().get(0);
                if (!parents.add(parent)) {
                    forkPoints.add(parent);
                } else {
                    heads.remove(parent);
                }
                Hash commitId = entry.getHash();
                if (!parents.contains(commitId)) {
                    heads.add(commitId);
                }
            });
        }
        heads.removeIf(parents::contains);
        return HeadsAndForkPoints.of(heads, forkPoints, scanStartedAtInMicros);
    }

    public ReferencedAndUnreferencedHeads identifyReferencedAndUnreferencedHeads(HeadsAndForkPoints headsAndForkPoints) throws ReferenceNotFoundException {
        Map<Hash, Set<NamedRef>> referenced = ReferencesUtil.newOpenAddressingHashMap();
        Set<Hash> heads = headsAndForkPoints.getHeads();
        Set<Hash> unreferenced = ReferencesUtil.newOpenAddressingHashSet(heads);
        long stopAtCommitTimeMicros = headsAndForkPoints.getScanStartedAtInMicros() - this.databaseAdapter.getConfig().getAssumedWallClockDriftMicros();
        try (Stream<ReferenceInfo<ByteString>> namedRefs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);){
            namedRefs.forEach(refInfo -> {
                try (Stream<CommitLogEntry> logs = this.databaseAdapter.commitLog(refInfo.getHash());){
                    if (!referenced.containsKey(refInfo.getHash())) {
                        CommitLogEntry entry;
                        Hash commitId;
                        Iterator logIter = logs.iterator();
                        while (logIter.hasNext() && !referenced.containsKey(commitId = (entry = (CommitLogEntry)logIter.next()).getHash())) {
                            if (heads.contains(commitId)) {
                                unreferenced.remove(entry.getHash());
                            }
                            if (entry.getCreatedTime() >= stopAtCommitTimeMicros) continue;
                            break;
                        }
                    }
                    referenced.computeIfAbsent(refInfo.getHash(), x -> ReferencesUtil.newOpenAddressingHashSet()).add(refInfo.getNamedRef());
                }
                catch (ReferenceNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return ReferencedAndUnreferencedHeads.of(referenced, unreferenced);
    }
}

