/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyWithBytes", generator="Immutables")
@Immutable
public final class ImmutableKeyWithBytes
implements KeyWithBytes {
    private final Key key;
    private final ContentId contentId;
    private final byte payload;
    private final ByteString value;

    private ImmutableKeyWithBytes(Key key, ContentId contentId, byte payload, ByteString value) {
        this.key = key;
        this.contentId = contentId;
        this.payload = payload;
        this.value = value;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public ContentId getContentId() {
        return this.contentId;
    }

    @Override
    public byte getPayload() {
        return this.payload;
    }

    @Override
    public ByteString getValue() {
        return this.value;
    }

    public final ImmutableKeyWithBytes withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableKeyWithBytes(newValue, this.contentId, this.payload, this.value);
    }

    public final ImmutableKeyWithBytes withContentId(ContentId value) {
        if (this.contentId == value) {
            return this;
        }
        ContentId newValue = Objects.requireNonNull(value, "contentId");
        return new ImmutableKeyWithBytes(this.key, newValue, this.payload, this.value);
    }

    public final ImmutableKeyWithBytes withPayload(byte value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableKeyWithBytes(this.key, this.contentId, value, this.value);
    }

    public final ImmutableKeyWithBytes withValue(ByteString value) {
        if (this.value == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "value");
        return new ImmutableKeyWithBytes(this.key, this.contentId, this.payload, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyWithBytes && this.equalTo(0, (ImmutableKeyWithBytes)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyWithBytes another) {
        return this.key.equals((Object)another.key) && this.contentId.equals(another.contentId) && this.payload == another.payload && this.value.equals((Object)another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.contentId.hashCode();
        h += (h << 5) + Bytes.hashCode((byte)this.payload);
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyWithBytes").omitNullValues().add("key", (Object)this.key).add("contentId", (Object)this.contentId).add("payload", (int)this.payload).add("value", (Object)this.value).toString();
    }

    public static ImmutableKeyWithBytes copyOf(KeyWithBytes instance) {
        if (instance instanceof ImmutableKeyWithBytes) {
            return (ImmutableKeyWithBytes)instance;
        }
        return ImmutableKeyWithBytes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyWithBytes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT_ID = 2L;
        private static final long INIT_BIT_PAYLOAD = 4L;
        private static final long INIT_BIT_VALUE = 8L;
        private long initBits = 15L;
        @Nullable
        private Key key;
        @Nullable
        private ContentId contentId;
        private byte payload;
        @Nullable
        private ByteString value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyWithBytes instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.contentId(instance.getContentId());
            this.payload(instance.getPayload());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(ContentId contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(byte payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(ByteString value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableKeyWithBytes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyWithBytes(this.key, this.contentId, this.payload, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build KeyWithBytes, some of required attributes are not set " + attributes;
        }
    }
}

