/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.events;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.events.AdapterEvent;
import org.projectnessie.versioned.persist.adapter.events.CommittingEvent;
import org.projectnessie.versioned.persist.adapter.events.OperationType;
import org.projectnessie.versioned.persist.adapter.events.TransplantEvent;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransplantEvent", generator="Immutables")
@Immutable
public final class ImmutableTransplantEvent
implements TransplantEvent {
    private final long eventTimeMicros;
    private final BranchName branch;
    private final Hash previousHash;
    private final Hash hash;
    private final ImmutableList<CommitLogEntry> commits;
    private final OperationType operationType;

    private ImmutableTransplantEvent(Builder builder) {
        this.eventTimeMicros = builder.eventTimeMicros;
        this.branch = builder.branch;
        this.previousHash = builder.previousHash;
        this.hash = builder.hash;
        this.commits = builder.commits.build();
        this.operationType = builder.operationType != null ? builder.operationType : Objects.requireNonNull(TransplantEvent.super.getOperationType(), "operationType");
    }

    private ImmutableTransplantEvent(long eventTimeMicros, BranchName branch, Hash previousHash, Hash hash, ImmutableList<CommitLogEntry> commits, OperationType operationType) {
        this.eventTimeMicros = eventTimeMicros;
        this.branch = branch;
        this.previousHash = previousHash;
        this.hash = hash;
        this.commits = commits;
        this.operationType = operationType;
    }

    @Override
    public long getEventTimeMicros() {
        return this.eventTimeMicros;
    }

    @Override
    public BranchName getBranch() {
        return this.branch;
    }

    @Override
    public Hash getPreviousHash() {
        return this.previousHash;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    public ImmutableList<CommitLogEntry> getCommits() {
        return this.commits;
    }

    @Override
    public OperationType getOperationType() {
        return this.operationType;
    }

    public final ImmutableTransplantEvent withEventTimeMicros(long value) {
        if (this.eventTimeMicros == value) {
            return this;
        }
        return new ImmutableTransplantEvent(value, this.branch, this.previousHash, this.hash, this.commits, this.operationType);
    }

    public final ImmutableTransplantEvent withBranch(BranchName value) {
        if (this.branch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "branch");
        return new ImmutableTransplantEvent(this.eventTimeMicros, newValue, this.previousHash, this.hash, this.commits, this.operationType);
    }

    public final ImmutableTransplantEvent withPreviousHash(Hash value) {
        if (this.previousHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "previousHash");
        return new ImmutableTransplantEvent(this.eventTimeMicros, this.branch, newValue, this.hash, this.commits, this.operationType);
    }

    public final ImmutableTransplantEvent withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableTransplantEvent(this.eventTimeMicros, this.branch, this.previousHash, newValue, this.commits, this.operationType);
    }

    public final ImmutableTransplantEvent withCommits(CommitLogEntry ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransplantEvent(this.eventTimeMicros, this.branch, this.previousHash, this.hash, (ImmutableList<CommitLogEntry>)newValue, this.operationType);
    }

    public final ImmutableTransplantEvent withCommits(Iterable<? extends CommitLogEntry> elements) {
        if (this.commits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransplantEvent(this.eventTimeMicros, this.branch, this.previousHash, this.hash, (ImmutableList<CommitLogEntry>)newValue, this.operationType);
    }

    public final ImmutableTransplantEvent withOperationType(OperationType value) {
        OperationType newValue = Objects.requireNonNull(value, "operationType");
        if (this.operationType == newValue) {
            return this;
        }
        return new ImmutableTransplantEvent(this.eventTimeMicros, this.branch, this.previousHash, this.hash, this.commits, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransplantEvent && this.equalTo(0, (ImmutableTransplantEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransplantEvent another) {
        return this.eventTimeMicros == another.eventTimeMicros && this.branch.equals(another.branch) && this.previousHash.equals(another.previousHash) && this.hash.equals(another.hash) && this.commits.equals(another.commits) && this.operationType.equals((Object)another.operationType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.eventTimeMicros);
        h += (h << 5) + this.branch.hashCode();
        h += (h << 5) + this.previousHash.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.commits.hashCode();
        h += (h << 5) + this.operationType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransplantEvent").omitNullValues().add("eventTimeMicros", this.eventTimeMicros).add("branch", (Object)this.branch).add("previousHash", (Object)this.previousHash).add("hash", (Object)this.hash).add("commits", this.commits).add("operationType", (Object)this.operationType).toString();
    }

    public static ImmutableTransplantEvent copyOf(TransplantEvent instance) {
        if (instance instanceof ImmutableTransplantEvent) {
            return (ImmutableTransplantEvent)instance;
        }
        return ImmutableTransplantEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransplantEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TransplantEvent.Builder {
        private static final long INIT_BIT_EVENT_TIME_MICROS = 1L;
        private static final long INIT_BIT_BRANCH = 2L;
        private static final long INIT_BIT_PREVIOUS_HASH = 4L;
        private static final long INIT_BIT_HASH = 8L;
        private long initBits = 15L;
        private long eventTimeMicros;
        @Nullable
        private BranchName branch;
        @Nullable
        private Hash previousHash;
        @Nullable
        private Hash hash;
        private ImmutableList.Builder<CommitLogEntry> commits = ImmutableList.builder();
        @Nullable
        private OperationType operationType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TransplantEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CommittingEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AdapterEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AdapterEvent instance;
            long bits = 0L;
            if (object instanceof TransplantEvent) {
                instance = (TransplantEvent)object;
                if ((bits & 4L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllCommits(instance.getCommits());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.previousHash(instance.getPreviousHash());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.branch(instance.getBranch());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.hash(instance.getHash());
                    bits |= 0x20L;
                }
            }
            if (object instanceof CommittingEvent) {
                instance = (CommittingEvent)object;
                if ((bits & 4L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllCommits(instance.getCommits());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.previousHash(instance.getPreviousHash());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.branch(instance.getBranch());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.hash(instance.getHash());
                    bits |= 0x20L;
                }
            }
            if (object instanceof AdapterEvent) {
                instance = (AdapterEvent)object;
                if ((bits & 4L) == 0L) {
                    this.eventTimeMicros(instance.getEventTimeMicros());
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.operationType(instance.getOperationType());
                    bits |= 0x10L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder eventTimeMicros(long eventTimeMicros) {
            this.eventTimeMicros = eventTimeMicros;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder branch(BranchName branch) {
            this.branch = Objects.requireNonNull(branch, "branch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder previousHash(Hash previousHash) {
            this.previousHash = Objects.requireNonNull(previousHash, "previousHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addCommits(CommitLogEntry element) {
            this.commits.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommits(CommitLogEntry ... elements) {
            this.commits.add((Object[])elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder commits(Iterable<? extends CommitLogEntry> elements) {
            this.commits = ImmutableList.builder();
            return this.addAllCommits(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCommits(Iterable<? extends CommitLogEntry> elements) {
            this.commits.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder operationType(OperationType operationType) {
            this.operationType = Objects.requireNonNull(operationType, "operationType");
            return this;
        }

        @Override
        public ImmutableTransplantEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransplantEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("eventTimeMicros");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("branch");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("previousHash");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build TransplantEvent, some of required attributes are not set " + attributes;
        }
    }
}

