/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.dynamodb;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BackendLimitExceededException;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.dynamodb.DynamoDatabaseClient;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.projectnessie.versioned.persist.serialize.ProtoSerialization;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class DynamoDatabaseAdapter
extends NonTransactionalDatabaseAdapter<NonTransactionalDatabaseAdapterConfig> {
    private static final int DYNAMO_BATCH_WRITE_MAX_REQUESTS = 25;
    private static final char PREFIX_SEPARATOR = ':';
    private final DynamoDatabaseClient client;
    private final String keyPrefix;
    private final Map<String, AttributeValue> globalPointerKeyMap;

    public DynamoDatabaseAdapter(NonTransactionalDatabaseAdapterConfig config, DynamoDatabaseClient c) {
        super(config);
        Objects.requireNonNull(c, "Requires a non-null DynamoDatabaseClient from DynamoDatabaseAdapterConfig");
        this.client = c;
        String keyPrefix = config.getRepositoryId();
        if (keyPrefix.indexOf(58) >= 0) {
            throw new IllegalArgumentException("Invalid key prefix: " + keyPrefix);
        }
        this.keyPrefix = keyPrefix + ':';
        this.globalPointerKeyMap = Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix).build());
    }

    @Nonnull
    @VisibleForTesting
    static RuntimeException unhandledException(String operation, RuntimeException e) {
        if (e instanceof RequestLimitExceededException) {
            return new BackendLimitExceededException(String.format("Dynamo request-limit exceeded during %s.", operation), (Throwable)e);
        }
        if (e instanceof LimitExceededException) {
            return new BackendLimitExceededException(String.format("Dynamo limit exceeded during %s.", operation), (Throwable)e);
        }
        if (e instanceof ProvisionedThroughputExceededException) {
            return new BackendLimitExceededException(String.format("Dynamo provisioned throughput exceeded during %s.", operation), (Throwable)e);
        }
        return e;
    }

    public void eraseRepo() {
        this.client.client.deleteItem(b -> b.tableName("global_pointer").key(this.globalPointerKeyMap).build());
        Stream.of("global_log", "commit_log", "key_lists", "ref_log").forEach(table -> this.client.client.scanPaginator(b -> b.tableName(table)).forEach(r -> r.items().stream().map(attrs -> (AttributeValue)attrs.get("key")).filter(key -> key.s().startsWith(this.keyPrefix)).forEach(key -> this.client.client.deleteItem(b -> b.tableName(table).key(Collections.singletonMap("key", key))))));
    }

    private <T> T loadById(String table, Hash id, ProtoSerialization.Parser<T> parser) {
        return this.loadById(table, id.asString(), parser);
    }

    private <T> T loadById(String table, String id, ProtoSerialization.Parser<T> parser) {
        byte[] data = this.loadById(table, id);
        try {
            return (T)(data != null ? parser.parse(data) : null);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] loadById(String table, String id) {
        Map<String, AttributeValue> key = Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + id).build());
        GetItemResponse response = this.client.client.getItem(b -> b.tableName(table).key(key));
        if (!response.hasItem()) {
            return null;
        }
        Map attributes = response.item();
        SdkBytes bytes = ((AttributeValue)attributes.get("val")).b();
        return bytes.asByteArray();
    }

    protected AdapterTypes.GlobalStatePointer fetchGlobalPointer(NonTransactionalOperationContext ctx) {
        return (AdapterTypes.GlobalStatePointer)this.loadById("global_pointer", "", AdapterTypes.GlobalStatePointer::parseFrom);
    }

    protected CommitLogEntry fetchFromCommitLog(NonTransactionalOperationContext ctx, Hash hash) {
        return (CommitLogEntry)this.loadById("commit_log", hash, ProtoSerialization::protoToCommitLogEntry);
    }

    protected AdapterTypes.GlobalStateLogEntry fetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        return (AdapterTypes.GlobalStateLogEntry)this.loadById("global_log", id, AdapterTypes.GlobalStateLogEntry::parseFrom);
    }

    protected List<CommitLogEntry> fetchPageFromCommitLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPageResult("commit_log", hashes, ProtoSerialization::protoToCommitLogEntry);
    }

    protected List<AdapterTypes.GlobalStateLogEntry> fetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPageResult("global_log", hashes, AdapterTypes.GlobalStateLogEntry::parseFrom);
    }

    protected Stream<KeyListEntity> fetchKeyLists(NonTransactionalOperationContext ctx, List<Hash> keyListsIds) {
        Map map = this.fetchPage("key_lists", keyListsIds, ProtoSerialization::protoToKeyList);
        return keyListsIds.stream().map(h -> map.containsKey(h) ? KeyListEntity.of((Hash)h, (KeyList)((KeyList)map.get(h))) : null);
    }

    protected void writeGlobalCommit(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStateLogEntry entry) {
        this.insert("global_log", Hash.of((ByteString)entry.getId()).asString(), entry.toByteArray());
    }

    protected void writeIndividualCommit(NonTransactionalOperationContext ctx, CommitLogEntry entry) {
        this.insert("commit_log", entry.getHash().asString(), ProtoSerialization.toProto((CommitLogEntry)entry).toByteArray());
    }

    protected void unsafeWriteGlobalPointer(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) {
        this.insert("global_pointer", "", pointer.toByteArray());
    }

    protected void writeMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) {
        this.batchWrite("commit_log", entries, CommitLogEntry::getHash, e -> ProtoSerialization.toProto((CommitLogEntry)e).toByteArray());
    }

    protected void writeKeyListEntities(NonTransactionalOperationContext ctx, List<KeyListEntity> newKeyListEntities) {
        this.batchWrite("key_lists", newKeyListEntities, KeyListEntity::getId, e -> ProtoSerialization.toProto((KeyList)e.getKeys()).toByteArray());
    }

    protected boolean globalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        AttributeValue expectedBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])expected.toByteArray())).build();
        AttributeValue newPointerBytes = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])newPointer.toByteArray())).build();
        try {
            this.client.client.updateItem(b -> b.tableName("global_pointer").key(this.globalPointerKeyMap).expected(Collections.singletonMap("val", (ExpectedAttributeValue)ExpectedAttributeValue.builder().value(expectedBytes).build())).attributeUpdates(Collections.singletonMap("val", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(newPointerBytes).build())));
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    protected void cleanUpCommitCas(NonTransactionalOperationContext ctx, Hash globalId, Set<Hash> branchCommits, Set<Hash> newKeyLists, Hash refLogId) {
        HashMap<String, List<WriteRequest>> requestItems = new HashMap<String, List<WriteRequest>>();
        if (!branchCommits.isEmpty()) {
            requestItems.put("commit_log", this.cleanupDeletes(branchCommits));
        }
        if (!newKeyLists.isEmpty()) {
            requestItems.put("key_lists", this.cleanupDeletes(newKeyLists));
        }
        requestItems.put("global_log", this.cleanupDeletes(Collections.singleton(globalId)));
        requestItems.put("ref_log", this.cleanupDeletes(Collections.singleton(refLogId)));
        this.client.client.batchWriteItem(b -> b.requestItems(requestItems));
    }

    private List<WriteRequest> cleanupDeletes(Set<Hash> hashes) {
        ArrayList<WriteRequest> requests = new ArrayList<WriteRequest>();
        for (Hash hash : hashes) {
            requests.add((WriteRequest)WriteRequest.builder().deleteRequest(b -> b.key(Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + hash.asString()).build()))).build());
        }
        return requests;
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyWithType entry) {
        return ProtoSerialization.toProto((KeyWithType)entry).getSerializedSize();
    }

    private <T> List<T> fetchPageResult(String table, List<Hash> hashes, ProtoSerialization.Parser<T> parser) {
        Map<Hash, T> map = this.fetchPage(table, hashes, parser);
        return hashes.stream().map(map::get).collect(Collectors.toList());
    }

    private <T> Map<Hash, T> fetchPage(String table, List<Hash> hashes, ProtoSerialization.Parser<T> parser) {
        List keys = hashes.stream().map(h -> this.keyPrefix + h.asString()).map(k -> (AttributeValue)AttributeValue.builder().s(k).build()).map(k -> Collections.singletonMap("key", k)).collect(Collectors.toList());
        Map<String, KeysAndAttributes> requestItems = Collections.singletonMap(table, (KeysAndAttributes)KeysAndAttributes.builder().attributesToGet(new String[]{"key", "val"}).keys(keys).build());
        BatchGetItemResponse response = this.client.client.batchGetItem(b -> b.requestItems(requestItems));
        if (!response.hasResponses()) {
            return Collections.emptyMap();
        }
        if (response.hasUnprocessedKeys() && !response.unprocessedKeys().isEmpty()) {
            throw new IllegalArgumentException("Requested too many keys, unprocessed keys: " + response.unprocessedKeys());
        }
        List items = (List)response.responses().get(table);
        return items.stream().collect(Collectors.toMap(m -> Hash.of((String)((AttributeValue)m.get("key")).s().substring(this.keyPrefix.length())), m -> {
            try {
                return parser.parse(((AttributeValue)m.get("val")).b().asByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private void insert(String table, String key, byte[] data) {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put("key", (AttributeValue)AttributeValue.builder().s(this.keyPrefix + key).build());
        item.put("val", (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])data)).build());
        this.client.client.putItem(b -> b.tableName(table).item(item));
    }

    private <T> void batchWrite(String tableName, List<T> entries, Function<T, Hash> id, Function<T, byte[]> serializer) {
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<WriteRequest> requests = new ArrayList<WriteRequest>();
        for (T entry : entries) {
            HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            String key = this.keyPrefix + id.apply(entry).asString();
            item.put("key", (AttributeValue)AttributeValue.builder().s(key).build());
            item.put("val", (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])serializer.apply(entry))).build());
            if (requests.size() == 25) {
                this.client.client.batchWriteItem(b -> b.requestItems(Collections.singletonMap(tableName, requests)));
                requests.clear();
            }
            WriteRequest write = (WriteRequest)WriteRequest.builder().putRequest(b -> b.item(item)).build();
            requests.add(write);
        }
        this.client.client.batchWriteItem(b -> b.requestItems(Collections.singletonMap(tableName, requests)));
    }

    protected void writeRefLog(NonTransactionalOperationContext ctx, AdapterTypes.RefLogEntry entry) throws ReferenceConflictException {
        this.insert("ref_log", Hash.of((ByteString)entry.getRefLogId()).asString(), entry.toByteArray());
    }

    protected RefLog fetchFromRefLog(NonTransactionalOperationContext ctx, Hash refLogId) {
        if (refLogId == null) {
            refLogId = Hash.of((ByteString)this.fetchGlobalPointer(ctx).getRefLogId());
        }
        return (RefLog)this.loadById("ref_log", refLogId, ProtoSerialization::protoToRefLog);
    }

    protected List<RefLog> fetchPageFromRefLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPageResult("ref_log", hashes, ProtoSerialization::protoToRefLog);
    }
}

