/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.dynamodb;

import java.net.URI;
import java.util.List;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionProvider;
import org.projectnessie.versioned.persist.dynamodb.DefaultDynamoClientConfig;
import org.projectnessie.versioned.persist.dynamodb.DynamoClientConfig;
import org.projectnessie.versioned.persist.dynamodb.ProvidedDynamoClientConfig;
import org.projectnessie.versioned.persist.dynamodb.Tables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;

public class DynamoDatabaseClient
implements DatabaseConnectionProvider<DynamoClientConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDatabaseClient.class);
    DynamoDbClient client;
    private boolean externallyProvidedClient;
    private DynamoClientConfig config;

    public void configure(DynamoClientConfig config) {
        this.config = config;
    }

    public void initialize() {
        if (this.client != null) {
            throw new IllegalStateException("Already initialized.");
        }
        if (this.config instanceof DefaultDynamoClientConfig) {
            DefaultDynamoClientConfig cfg = (DefaultDynamoClientConfig)this.config;
            DynamoDbClientBuilder clientBuilder = (DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClient(UrlConnectionHttpClient.create())).region(Region.of((String)cfg.getRegion()));
            if (cfg.getCredentialsProvider() != null) {
                clientBuilder = (DynamoDbClientBuilder)clientBuilder.credentialsProvider(cfg.getCredentialsProvider());
            }
            if (cfg.getEndpointURI() != null) {
                clientBuilder = (DynamoDbClientBuilder)clientBuilder.endpointOverride(URI.create(cfg.getEndpointURI()));
            }
            this.externallyProvidedClient = false;
            this.client = (DynamoDbClient)clientBuilder.build();
        } else if (this.config instanceof ProvidedDynamoClientConfig) {
            ProvidedDynamoClientConfig cfg = (ProvidedDynamoClientConfig)this.config;
            this.externallyProvidedClient = true;
            this.client = cfg.getDynamoDbClient();
        } else {
            throw new IllegalArgumentException("Must provide a Dynamo-client-configuration of type DefaultDynamoClientConfig or ProvidedDynamoClientConfig.");
        }
        Tables.all().forEach(this::createIfMissing);
    }

    public void close() {
        if (this.client != null) {
            try {
                if (!this.externallyProvidedClient) {
                    this.client.close();
                }
            }
            finally {
                this.client = null;
            }
        }
    }

    private void createIfMissing(String name) {
        if (!this.tableExists(name)) {
            this.createTable(name);
        }
    }

    private boolean tableExists(String name) {
        try {
            DescribeTableResponse table = this.client.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(name).build());
            DynamoDatabaseClient.verifyKeySchema(table.table());
            return true;
        }
        catch (ResourceNotFoundException e) {
            LOGGER.debug("Didn't find table '{}', going to create one.", (Object)name, (Object)e);
            return false;
        }
    }

    private void createTable(String name) {
        this.client.createTable((CreateTableRequest)CreateTableRequest.builder().tableName(name).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("key").attributeType(ScalarAttributeType.S).build()}).billingMode(BillingMode.PAY_PER_REQUEST).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("key").keyType(KeyType.HASH).build()}).build());
    }

    private static void verifyKeySchema(TableDescription description) {
        KeySchemaElement key;
        List elements = description.keySchema();
        if (elements.size() == 1 && (key = (KeySchemaElement)elements.get(0)).attributeName().equals("key") && key.keyType() == KeyType.HASH) {
            return;
        }
        throw new IllegalStateException(String.format("Invalid key schema for table: %s. Key schema should be a hash partitioned attribute with the name 'id'.", description.tableName()));
    }
}

