/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.dynamodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.dynamodb.ProvidedDynamoClientConfig;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProvidedDynamoClientConfig", generator="Immutables")
@Immutable
public final class ImmutableProvidedDynamoClientConfig
implements ProvidedDynamoClientConfig {
    private final DynamoDbClient dynamoDbClient;

    private ImmutableProvidedDynamoClientConfig(DynamoDbClient dynamoDbClient) {
        this.dynamoDbClient = dynamoDbClient;
    }

    @Override
    public DynamoDbClient getDynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public final ImmutableProvidedDynamoClientConfig withDynamoDbClient(DynamoDbClient value) {
        if (this.dynamoDbClient == value) {
            return this;
        }
        DynamoDbClient newValue = Objects.requireNonNull(value, "dynamoDbClient");
        return new ImmutableProvidedDynamoClientConfig(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProvidedDynamoClientConfig && this.equalTo(0, (ImmutableProvidedDynamoClientConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableProvidedDynamoClientConfig another) {
        return this.dynamoDbClient.equals(another.dynamoDbClient);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.dynamoDbClient.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProvidedDynamoClientConfig").omitNullValues().add("dynamoDbClient", (Object)this.dynamoDbClient).toString();
    }

    public static ImmutableProvidedDynamoClientConfig copyOf(ProvidedDynamoClientConfig instance) {
        if (instance instanceof ImmutableProvidedDynamoClientConfig) {
            return (ImmutableProvidedDynamoClientConfig)instance;
        }
        return ImmutableProvidedDynamoClientConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProvidedDynamoClientConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DYNAMO_DB_CLIENT = 1L;
        private long initBits = 1L;
        @Nullable
        private DynamoDbClient dynamoDbClient;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ProvidedDynamoClientConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.dynamoDbClient(instance.getDynamoDbClient());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dynamoDbClient(DynamoDbClient dynamoDbClient) {
            this.dynamoDbClient = Objects.requireNonNull(dynamoDbClient, "dynamoDbClient");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableProvidedDynamoClientConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProvidedDynamoClientConfig(this.dynamoDbClient);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dynamoDbClient");
            }
            return "Cannot build ProvidedDynamoClientConfig, some of required attributes are not set " + attributes;
        }
    }
}

