/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.mongodb;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.MongoDBContainer;

public class LocalMongo {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalMongo.class);
    public static final String MONGO_DB_NAME = "test";
    public static final int MONGO_PORT = 27017;
    private MongoDBContainer container;
    private String connectionString;

    public MongoDBContainer getContainer() {
        return this.container;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getDatabaseName() {
        return MONGO_DB_NAME;
    }

    public void startMongo(Optional<String> containerNetworkId, boolean quiet) {
        if (this.container != null) {
            throw new IllegalStateException("Already started");
        }
        String version = System.getProperty("it.nessie.container.mongodb.tag", "4.2-bionic");
        if (!quiet) {
            LOGGER.info("Starting Mongo test container (network-id: {})", containerNetworkId);
        }
        this.container = (MongoDBContainer)new MongoDBContainer("mongo:" + version).withLogConsumer(outputFrame -> {});
        containerNetworkId.ifPresent(arg_0 -> ((MongoDBContainer)this.container).withNetworkMode(arg_0));
        try {
            this.container.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.connectionString = this.container.getReplicaSetUrl(MONGO_DB_NAME);
        if (containerNetworkId.isPresent()) {
            String hostPort = this.container.getHost() + ':' + this.container.getMappedPort(27017);
            String networkHostPort = this.container.getCurrentContainerInfo().getConfig().getHostName() + ':' + 27017;
            this.connectionString = this.connectionString.replace(hostPort, networkHostPort);
        }
        if (!quiet) {
            LOGGER.info("Mongo test container connection string is {} (network-id: {})", (Object)this.connectionString, containerNetworkId);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        finally {
            this.container = null;
        }
    }
}

