/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.mongodb;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.mongodb.MongoDatabaseClient;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.projectnessie.versioned.persist.serialize.ProtoSerialization;

public class MongoDatabaseAdapter
extends NonTransactionalDatabaseAdapter<NonTransactionalDatabaseAdapterConfig> {
    private static final String ID_PROPERTY_NAME = "_id";
    private static final String ID_REPO_NAME = "repo";
    private static final String ID_HASH_NAME = "hash";
    private static final String ID_REPO_PATH = "_id.repo";
    private static final String DATA_PROPERTY_NAME = "data";
    private static final String GLOBAL_ID_PROPERTY_NAME = "globalId";
    private final String repositoryId;
    private final String globalPointerKey;
    private final MongoDatabaseClient client;

    protected MongoDatabaseAdapter(NonTransactionalDatabaseAdapterConfig config, MongoDatabaseClient client) {
        super(config);
        Objects.requireNonNull(client, "MongoDatabaseClient cannot be null");
        this.client = client;
        this.repositoryId = config.getRepositoryId();
        Objects.requireNonNull(this.repositoryId, "Repository ID cannot be null");
        this.globalPointerKey = this.repositoryId;
    }

    public void eraseRepo() {
        this.client.getGlobalPointers().deleteMany(Filters.eq((Object)this.globalPointerKey));
        Bson idPrefixFilter = Filters.eq((String)ID_REPO_PATH, (Object)this.repositoryId);
        this.client.getGlobalLog().deleteMany(idPrefixFilter);
        this.client.getCommitLog().deleteMany(idPrefixFilter);
        this.client.getKeyLists().deleteMany(idPrefixFilter);
        this.client.getRefLog().deleteMany(idPrefixFilter);
    }

    private Document toId(Hash id) {
        Document idDoc = new Document();
        idDoc.put(ID_REPO_NAME, (Object)this.repositoryId);
        idDoc.put(ID_HASH_NAME, (Object)id.asString());
        return idDoc;
    }

    private List<Document> toIds(Collection<Hash> ids) {
        return ids.stream().map(this::toId).collect(Collectors.toList());
    }

    private Document toDoc(Hash id, byte[] data) {
        return MongoDatabaseAdapter.toDoc(this.toId(id), data);
    }

    private static Document toDoc(Document id, byte[] data) {
        Document doc = new Document();
        doc.put(ID_PROPERTY_NAME, (Object)id);
        doc.put(DATA_PROPERTY_NAME, (Object)data);
        return doc;
    }

    private Document toDoc(AdapterTypes.GlobalStatePointer pointer) {
        Document doc = new Document();
        doc.put(ID_PROPERTY_NAME, (Object)this.globalPointerKey);
        doc.put(DATA_PROPERTY_NAME, (Object)pointer.toByteArray());
        doc.put(GLOBAL_ID_PROPERTY_NAME, (Object)pointer.getGlobalId().toByteArray());
        return doc;
    }

    private void insert(MongoCollection<Document> collection, Hash id, byte[] data) throws ReferenceConflictException {
        MongoDatabaseAdapter.insert(collection, this.toDoc(id, data));
    }

    private static void insert(MongoCollection<Document> collection, Document doc) throws ReferenceConflictException {
        InsertOneResult result;
        try {
            result = collection.insertOne((Object)doc);
        }
        catch (MongoWriteException writeException) {
            ErrorCategory category = writeException.getError().getCategory();
            if (ErrorCategory.DUPLICATE_KEY.equals((Object)category)) {
                ReferenceConflictException ex = DatabaseAdapterUtil.hashCollisionDetected();
                ex.initCause((Throwable)writeException);
                throw ex;
            }
            throw writeException;
        }
        if (!result.wasAcknowledged()) {
            throw new IllegalStateException("Unacknowledged write to " + collection.getNamespace());
        }
    }

    private static void insert(MongoCollection<Document> collection, List<Document> docs) throws ReferenceConflictException {
        InsertManyResult result;
        if (docs.isEmpty()) {
            return;
        }
        try {
            result = collection.insertMany(docs);
        }
        catch (MongoWriteException writeException) {
            ErrorCategory category = writeException.getError().getCategory();
            if (ErrorCategory.DUPLICATE_KEY.equals((Object)category)) {
                ReferenceConflictException ex = DatabaseAdapterUtil.hashCollisionDetected();
                ex.initCause((Throwable)writeException);
                throw ex;
            }
            throw writeException;
        }
        if (!result.wasAcknowledged()) {
            throw new IllegalStateException("Unacknowledged write to " + collection.getNamespace());
        }
    }

    private void delete(MongoCollection<Document> collection, Set<Hash> ids) {
        DeleteResult result = collection.deleteMany(Filters.in((String)ID_PROPERTY_NAME, this.toIds(ids)));
        if (!result.wasAcknowledged()) {
            throw new IllegalStateException("Unacknowledged write to " + collection.getNamespace());
        }
    }

    private <ID> byte[] loadById(MongoCollection<Document> collection, ID id) {
        Document doc = (Document)collection.find(Filters.eq(id)).first();
        if (doc == null) {
            return null;
        }
        Binary data = (Binary)doc.get((Object)DATA_PROPERTY_NAME, Binary.class);
        if (data == null) {
            return null;
        }
        return data.getData();
    }

    private <T> T loadById(MongoCollection<Document> collection, Hash id, ProtoSerialization.Parser<T> parser) {
        return this.loadById(collection, this.toId(id), parser);
    }

    private <T, ID> T loadById(MongoCollection<Document> collection, ID id, ProtoSerialization.Parser<T> parser) {
        byte[] data = this.loadById(collection, id);
        if (data == null) {
            return null;
        }
        try {
            return (T)parser.parse(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
    }

    private <T> List<T> fetchMappedPage(MongoCollection<Document> collection, List<Hash> hashes, Function<Document, T> mapper) {
        List ids = hashes.stream().map(this::toId).collect(Collectors.toList());
        FindIterable docs = collection.find(Filters.in((String)ID_PROPERTY_NAME, ids)).limit(hashes.size());
        HashMap<Hash, Document> loaded = new HashMap<Hash, Document>(hashes.size() * 4 / 3 + 1, 0.75f);
        for (Document doc : docs) {
            loaded.put(this.idAsHash(doc), doc);
        }
        ArrayList<Object> result = new ArrayList<Object>(hashes.size());
        for (Hash hash : hashes) {
            Object element = null;
            Document document = (Document)loaded.get(hash);
            if (document != null) {
                element = mapper.apply(document);
            }
            result.add(element);
        }
        return result;
    }

    private <T> List<T> fetchPage(MongoCollection<Document> collection, List<Hash> hashes, ProtoSerialization.Parser<T> parser) {
        return this.fetchMappedPage(collection, hashes, document -> {
            try {
                byte[] data = MongoDatabaseAdapter.data(document);
                return parser.parse(data);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    protected CommitLogEntry fetchFromCommitLog(NonTransactionalOperationContext ctx, Hash hash) {
        return (CommitLogEntry)this.loadById(this.client.getCommitLog(), (Object)hash, (ProtoSerialization.Parser)ProtoSerialization::protoToCommitLogEntry);
    }

    private Hash idAsHash(Document doc) {
        Document id = (Document)doc.get((Object)ID_PROPERTY_NAME, Document.class);
        String repo = id.getString((Object)ID_REPO_NAME);
        if (!this.repositoryId.equals(repo)) {
            throw new IllegalStateException(String.format("Repository mismatch for id '%s' (expected repository ID: '%s')", id, this.repositoryId));
        }
        String hash = id.getString((Object)ID_HASH_NAME);
        return Hash.of((String)hash);
    }

    private static byte[] data(Document doc) {
        return ((Binary)doc.get((Object)DATA_PROPERTY_NAME, Binary.class)).getData();
    }

    protected List<CommitLogEntry> fetchPageFromCommitLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.client.getCommitLog(), hashes, ProtoSerialization::protoToCommitLogEntry);
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyWithType entry) {
        return ProtoSerialization.toProto((KeyWithType)entry).getSerializedSize();
    }

    protected Stream<KeyListEntity> fetchKeyLists(NonTransactionalOperationContext ctx, List<Hash> keyListsIds) {
        return this.fetchMappedPage(this.client.getKeyLists(), keyListsIds, document -> {
            Hash hash = this.idAsHash((Document)document);
            KeyList keyList = ProtoSerialization.protoToKeyList((byte[])MongoDatabaseAdapter.data(document));
            return KeyListEntity.of((Hash)hash, (KeyList)keyList);
        }).stream();
    }

    protected void writeIndividualCommit(NonTransactionalOperationContext ctx, CommitLogEntry entry) throws ReferenceConflictException {
        this.insert(this.client.getCommitLog(), entry.getHash(), ProtoSerialization.toProto((CommitLogEntry)entry).toByteArray());
    }

    protected void writeMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) throws ReferenceConflictException {
        List<Document> docs = entries.stream().map(e -> this.toDoc(e.getHash(), ProtoSerialization.toProto((CommitLogEntry)e).toByteArray())).collect(Collectors.toList());
        MongoDatabaseAdapter.insert(this.client.getCommitLog(), docs);
    }

    protected void writeKeyListEntities(NonTransactionalOperationContext ctx, List<KeyListEntity> newKeyListEntities) {
        for (KeyListEntity keyList : newKeyListEntities) {
            try {
                this.insert(this.client.getKeyLists(), keyList.getId(), ProtoSerialization.toProto((KeyList)keyList.getKeys()).toByteArray());
            }
            catch (ReferenceConflictException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void writeGlobalCommit(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStateLogEntry entry) throws ReferenceConflictException {
        Document id = this.toId(Hash.of((ByteString)entry.getId()));
        MongoDatabaseAdapter.insert(this.client.getGlobalLog(), MongoDatabaseAdapter.toDoc(id, entry.toByteArray()));
    }

    protected void unsafeWriteGlobalPointer(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) {
        Document doc = this.toDoc(pointer);
        UpdateResult result = this.client.getGlobalPointers().updateOne(Filters.eq((Object)this.globalPointerKey), (Bson)new Document("$set", (Object)doc), new UpdateOptions().upsert(true));
        if (!result.wasAcknowledged()) {
            throw new IllegalStateException("Unacknowledged write to " + this.client.getGlobalPointers().getNamespace());
        }
    }

    protected boolean globalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        Document doc = this.toDoc(newPointer);
        byte[] expectedGlobalId = expected.getGlobalId().toByteArray();
        UpdateResult result = this.client.getGlobalPointers().replaceOne(Filters.and((Bson[])new Bson[]{Filters.eq((Object)this.globalPointerKey), Filters.eq((String)GLOBAL_ID_PROPERTY_NAME, (Object)expectedGlobalId)}), (Object)doc);
        return result.wasAcknowledged() && result.getMatchedCount() == 1L && result.getModifiedCount() == 1L;
    }

    protected void cleanUpCommitCas(NonTransactionalOperationContext ctx, Hash globalId, Set<Hash> branchCommits, Set<Hash> newKeyLists, Hash refLogId) {
        this.client.getGlobalLog().deleteOne(Filters.eq((Object)this.toId(globalId)));
        this.delete(this.client.getCommitLog(), branchCommits);
        this.delete(this.client.getKeyLists(), newKeyLists);
        this.client.getRefLog().deleteOne(Filters.eq((Object)this.toId(refLogId)));
    }

    protected AdapterTypes.GlobalStatePointer fetchGlobalPointer(NonTransactionalOperationContext ctx) {
        return (AdapterTypes.GlobalStatePointer)this.loadById(this.client.getGlobalPointers(), this.globalPointerKey, AdapterTypes.GlobalStatePointer::parseFrom);
    }

    protected AdapterTypes.GlobalStateLogEntry fetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        return (AdapterTypes.GlobalStateLogEntry)this.loadById(this.client.getGlobalLog(), (Object)id, (ProtoSerialization.Parser)AdapterTypes.GlobalStateLogEntry::parseFrom);
    }

    protected List<AdapterTypes.GlobalStateLogEntry> fetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.client.getGlobalLog(), hashes, AdapterTypes.GlobalStateLogEntry::parseFrom);
    }

    protected void writeRefLog(NonTransactionalOperationContext ctx, AdapterTypes.RefLogEntry entry) throws ReferenceConflictException {
        Document id = this.toId(Hash.of((ByteString)entry.getRefLogId()));
        MongoDatabaseAdapter.insert(this.client.getRefLog(), MongoDatabaseAdapter.toDoc(id, entry.toByteArray()));
    }

    protected RefLog fetchFromRefLog(NonTransactionalOperationContext ctx, Hash refLogId) {
        if (refLogId == null) {
            refLogId = Hash.of((ByteString)this.fetchGlobalPointer(ctx).getRefLogId());
        }
        return (RefLog)this.loadById(this.client.getRefLog(), (Object)refLogId, (ProtoSerialization.Parser)ProtoSerialization::protoToRefLog);
    }

    protected List<RefLog> fetchPageFromRefLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.client.getRefLog(), hashes, ProtoSerialization::protoToRefLog);
    }
}

