/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Objects;
import org.bson.Document;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionProvider;
import org.projectnessie.versioned.persist.mongodb.MongoClientConfig;

public class MongoDatabaseClient
implements DatabaseConnectionProvider<MongoClientConfig> {
    private static final String GLOBAL_POINTER = "global_pointer";
    private static final String GLOBAL_LOG = "global_log";
    private static final String COMMIT_LOG = "commit_log";
    private static final String KEY_LIST = "key_list";
    private static final String REF_LOG = "ref_log";
    private MongoClientConfig config;
    private MongoClient managedClient;
    private MongoCollection<Document> globalPointers;
    private MongoCollection<Document> globalLog;
    private MongoCollection<Document> commitLog;
    private MongoCollection<Document> keyLists;
    private MongoCollection<Document> refLog;

    public void configure(MongoClientConfig config) {
        this.config = config;
    }

    public void close() {
        if (this.managedClient != null) {
            try {
                this.managedClient.close();
            }
            finally {
                this.managedClient = null;
            }
        }
    }

    public void initialize() {
        MongoClient mongoClient = this.config.getClient();
        if (mongoClient == null) {
            ConnectionString cs = new ConnectionString(Objects.requireNonNull(this.config.getConnectionString(), "Connection string must be set"));
            MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(cs).build();
            mongoClient = this.managedClient = MongoClients.create((MongoClientSettings)settings);
        }
        MongoDatabase database = mongoClient.getDatabase(Objects.requireNonNull(this.config.getDatabaseName(), "Database name must be set"));
        this.globalPointers = database.getCollection(GLOBAL_POINTER);
        this.globalLog = database.getCollection(GLOBAL_LOG);
        this.commitLog = database.getCollection(COMMIT_LOG);
        this.keyLists = database.getCollection(KEY_LIST);
        this.refLog = database.getCollection(REF_LOG);
    }

    public MongoCollection<Document> getGlobalPointers() {
        return this.globalPointers;
    }

    public MongoCollection<Document> getGlobalLog() {
        return this.globalLog;
    }

    public MongoCollection<Document> getCommitLog() {
        return this.commitLog;
    }

    public MongoCollection<Document> getKeyLists() {
        return this.keyLists;
    }

    public MongoCollection<Document> getRefLog() {
        return this.refLog;
    }
}

