/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.rocks;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.rocks.RocksDbInstance;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.projectnessie.versioned.persist.serialize.ProtoSerialization;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.Holder;
import org.rocksdb.RocksDBException;
import org.rocksdb.TransactionDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDatabaseAdapter
extends NonTransactionalDatabaseAdapter<NonTransactionalDatabaseAdapterConfig> {
    private final TransactionDB db;
    private final RocksDbInstance dbInstance;
    private final ByteString keyPrefix;
    private final byte[] globalPointerKey;

    public RocksDatabaseAdapter(NonTransactionalDatabaseAdapterConfig config, RocksDbInstance dbInstance) {
        super(config);
        this.keyPrefix = ByteString.copyFromUtf8((String)(config.getRepositoryId() + ':'));
        this.globalPointerKey = ByteString.copyFromUtf8((String)config.getRepositoryId()).toByteArray();
        Objects.requireNonNull(dbInstance, "Requires a non-null RocksDbInstance from RocksDatabaseAdapterConfig");
        this.dbInstance = dbInstance;
        this.db = dbInstance.getDb();
    }

    private byte[] dbKey(Hash hash) {
        return this.keyPrefix.concat(hash.asBytes()).toByteArray();
    }

    private byte[] dbKey(ByteString key) {
        return this.keyPrefix.concat(key).toByteArray();
    }

    private byte[] globalPointerKey() {
        return this.globalPointerKey;
    }

    public void eraseRepo() {
        try {
            this.db.delete(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected AdapterTypes.GlobalStatePointer fetchGlobalPointer(NonTransactionalOperationContext ctx) {
        try {
            byte[] serialized = this.db.get(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey());
            return serialized != null ? AdapterTypes.GlobalStatePointer.parseFrom((byte[])serialized) : null;
        }
        catch (InvalidProtocolBufferException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeIndividualCommit(NonTransactionalOperationContext ctx, CommitLogEntry entry) throws ReferenceConflictException {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] key = this.dbKey(entry.getHash());
            if (this.db.keyMayExist(key, new Holder())) {
                throw DatabaseAdapterUtil.hashCollisionDetected();
            }
            this.db.put(this.dbInstance.getCfCommitLog(), key, ProtoSerialization.toProto((CommitLogEntry)entry).toByteArray());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void writeMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            WriteBatch batch = new WriteBatch();
            for (CommitLogEntry e : entries) {
                byte[] key = this.dbKey(e.getHash());
                batch.put(this.dbInstance.getCfCommitLog(), key, ProtoSerialization.toProto((CommitLogEntry)e).toByteArray());
            }
            this.db.write(new WriteOptions(), batch);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void writeGlobalCommit(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStateLogEntry entry) throws ReferenceConflictException {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] key = this.dbKey(entry.getId());
            if (this.db.keyMayExist(key, new Holder())) {
                throw DatabaseAdapterUtil.hashCollisionDetected();
            }
            this.db.put(this.dbInstance.getCfGlobalLog(), key, entry.toByteArray());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void unsafeWriteGlobalPointer(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) {
        try {
            this.db.put(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey(), pointer.toByteArray());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean globalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            AdapterTypes.GlobalStatePointer oldPointer;
            byte[] bytes = this.db.get(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey());
            AdapterTypes.GlobalStatePointer globalStatePointer = oldPointer = bytes != null ? AdapterTypes.GlobalStatePointer.parseFrom((byte[])bytes) : null;
            if (oldPointer == null || !oldPointer.getGlobalId().equals((Object)expected.getGlobalId())) {
                boolean bl = false;
                return bl;
            }
            this.db.put(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey(), newPointer.toByteArray());
            boolean bl = true;
            return bl;
        }
        catch (InvalidProtocolBufferException | RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void cleanUpCommitCas(NonTransactionalOperationContext ctx, Hash globalId, Set<Hash> branchCommits, Set<Hash> newKeyLists, Hash refLogId) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            WriteBatch batch = new WriteBatch();
            batch.delete(this.dbInstance.getCfGlobalLog(), this.dbKey(globalId));
            for (Hash h : branchCommits) {
                batch.delete(this.dbInstance.getCfCommitLog(), this.dbKey(h));
            }
            for (Hash h : newKeyLists) {
                batch.delete(this.dbInstance.getCfKeyList(), this.dbKey(h));
            }
            batch.delete(this.dbInstance.getCfRefLog(), this.dbKey(refLogId));
            this.db.write(new WriteOptions(), batch);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected AdapterTypes.GlobalStateLogEntry fetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        try {
            byte[] v = this.db.get(this.dbInstance.getCfGlobalLog(), this.dbKey(id));
            return v != null ? AdapterTypes.GlobalStateLogEntry.parseFrom((byte[])v) : null;
        }
        catch (InvalidProtocolBufferException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected CommitLogEntry fetchFromCommitLog(NonTransactionalOperationContext ctx, Hash hash) {
        try {
            byte[] v = this.db.get(this.dbInstance.getCfCommitLog(), this.dbKey(hash));
            return ProtoSerialization.protoToCommitLogEntry((byte[])v);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<CommitLogEntry> fetchPageFromCommitLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.dbInstance.getCfCommitLog(), hashes, ProtoSerialization::protoToCommitLogEntry);
    }

    protected List<AdapterTypes.GlobalStateLogEntry> fetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.dbInstance.getCfGlobalLog(), hashes, v -> {
            try {
                return v != null ? AdapterTypes.GlobalStateLogEntry.parseFrom((byte[])v) : null;
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> List<T> fetchPage(ColumnFamilyHandle cfHandle, List<Hash> hashes, Function<byte[], T> deserializer) {
        try {
            ArrayList<ColumnFamilyHandle> cf = new ArrayList<ColumnFamilyHandle>(hashes.size());
            for (int i = 0; i < hashes.size(); ++i) {
                cf.add(cfHandle);
            }
            List result = this.db.multiGetAsList(cf, hashes.stream().map(this::dbKey).collect(Collectors.toList()));
            return result.stream().map(deserializer).collect(Collectors.toList());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeKeyListEntities(NonTransactionalOperationContext ctx, List<KeyListEntity> newKeyListEntities) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            for (KeyListEntity keyListEntity : newKeyListEntities) {
                byte[] key = this.dbKey(keyListEntity.getId());
                this.db.put(this.dbInstance.getCfKeyList(), key, ProtoSerialization.toProto((KeyList)keyListEntity.getKeys()).toByteArray());
            }
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected Stream<KeyListEntity> fetchKeyLists(NonTransactionalOperationContext ctx, List<Hash> keyListsIds) {
        try {
            ArrayList<ColumnFamilyHandle> cf = new ArrayList<ColumnFamilyHandle>(keyListsIds.size());
            for (int i2 = 0; i2 < keyListsIds.size(); ++i2) {
                cf.add(this.dbInstance.getCfKeyList());
            }
            List result = this.db.multiGetAsList(cf, keyListsIds.stream().map(this::dbKey).collect(Collectors.toList()));
            return IntStream.range(0, keyListsIds.size()).mapToObj(i -> {
                byte[] v = (byte[])result.get(i);
                return KeyListEntity.of((Hash)((Hash)keyListsIds.get(i)), (KeyList)ProtoSerialization.protoToKeyList((byte[])v));
            });
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyWithType entry) {
        return ProtoSerialization.toProto((KeyWithType)entry).getSerializedSize();
    }

    protected void writeRefLog(NonTransactionalOperationContext ctx, AdapterTypes.RefLogEntry entry) throws ReferenceConflictException {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] key = this.dbKey(entry.getRefLogId());
            if (this.db.keyMayExist(key, new Holder())) {
                throw DatabaseAdapterUtil.hashCollisionDetected();
            }
            this.db.put(this.dbInstance.getCfRefLog(), key, entry.toByteArray());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected RefLog fetchFromRefLog(NonTransactionalOperationContext ctx, Hash refLogId) {
        if (refLogId == null) {
            refLogId = Hash.of((ByteString)this.fetchGlobalPointer(ctx).getRefLogId());
        }
        try {
            byte[] v = this.db.get(this.dbInstance.getCfRefLog(), this.dbKey(refLogId));
            return ProtoSerialization.protoToRefLog((byte[])v);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<RefLog> fetchPageFromRefLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.dbInstance.getCfRefLog(), hashes, ProtoSerialization::protoToRefLog);
    }
}

