/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.rocks;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.serialize.ProtoSerialization;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.rocks.RocksDbInstance;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.Holder;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TransactionDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDatabaseAdapter
extends NonTransactionalDatabaseAdapter<NonTransactionalDatabaseAdapterConfig> {
    private final TransactionDB db;
    private final RocksDbInstance dbInstance;
    private final ByteString keyPrefix;
    private final byte[] globalPointerKey;

    public RocksDatabaseAdapter(NonTransactionalDatabaseAdapterConfig config, RocksDbInstance dbInstance, AdapterEventConsumer eventConsumer) {
        super(config, eventConsumer);
        this.keyPrefix = ByteString.copyFromUtf8((String)(config.getRepositoryId() + ':'));
        this.globalPointerKey = ByteString.copyFromUtf8((String)config.getRepositoryId()).toByteArray();
        Objects.requireNonNull(dbInstance, "Requires a non-null RocksDbInstance from RocksDatabaseAdapterConfig");
        this.dbInstance = dbInstance;
        this.db = dbInstance.getDb();
    }

    private byte[] dbKey(Hash hash) {
        return this.keyPrefix.concat(hash.asBytes()).toByteArray();
    }

    private byte[] dbKey(ByteString key) {
        return this.keyPrefix.concat(key).toByteArray();
    }

    private byte[] dbKey(String key) {
        return this.dbKey(ByteString.copyFromUtf8((String)key));
    }

    private byte[] dbKey(int key) {
        return this.dbKey(Integer.toString(key));
    }

    private byte[] globalPointerKey() {
        return this.globalPointerKey;
    }

    protected void doEraseRepo() {
        try {
            this.db.delete(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey());
            this.dbInstance.allExceptGlobalPointer().forEach(cf -> {
                try (RocksIterator iter = this.db.newIterator(cf);){
                    ArrayList<ByteString> deletes = new ArrayList<ByteString>();
                    iter.seekToFirst();
                    while (iter.isValid()) {
                        ByteString key2 = ByteString.copyFrom((byte[])iter.key());
                        if (key2.startsWith(this.keyPrefix)) {
                            deletes.add(key2);
                        }
                        iter.next();
                    }
                    deletes.forEach(key -> {
                        try {
                            this.db.delete(cf, key.toByteArray());
                        }
                        catch (RocksDBException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
            });
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected AdapterTypes.GlobalStatePointer doFetchGlobalPointer(NonTransactionalOperationContext ctx) {
        try {
            byte[] serialized = this.db.get(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey());
            return serialized != null ? AdapterTypes.GlobalStatePointer.parseFrom((byte[])serialized) : null;
        }
        catch (InvalidProtocolBufferException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doWriteIndividualCommit(NonTransactionalOperationContext ctx, CommitLogEntry entry) throws ReferenceConflictException {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] key = this.dbKey(entry.getHash());
            this.checkForHashCollision(this.dbInstance.getCfCommitLog(), key);
            this.db.put(this.dbInstance.getCfCommitLog(), key, ProtoSerialization.toProto((CommitLogEntry)entry).toByteArray());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void doWriteMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) {
        this.persistMultipleCommits(entries);
    }

    protected void doUpdateMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) {
        this.persistMultipleCommits(entries);
    }

    private void persistMultipleCommits(List<CommitLogEntry> entries) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            WriteBatch batch = new WriteBatch();
            for (CommitLogEntry e : entries) {
                byte[] key = this.dbKey(e.getHash());
                batch.put(this.dbInstance.getCfCommitLog(), key, ProtoSerialization.toProto((CommitLogEntry)e).toByteArray());
            }
            this.db.write(new WriteOptions(), batch);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void unsafeWriteGlobalPointer(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) {
        try {
            this.db.put(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey(), pointer.toByteArray());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean doGlobalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            AdapterTypes.GlobalStatePointer oldPointer;
            byte[] bytes = this.db.get(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey());
            AdapterTypes.GlobalStatePointer globalStatePointer = oldPointer = bytes != null ? AdapterTypes.GlobalStatePointer.parseFrom((byte[])bytes) : null;
            if (oldPointer == null || !oldPointer.getGlobalId().equals((Object)expected.getGlobalId())) {
                boolean bl = false;
                return bl;
            }
            this.db.put(this.dbInstance.getCfGlobalPointer(), this.globalPointerKey(), newPointer.toByteArray());
            boolean bl = true;
            return bl;
        }
        catch (InvalidProtocolBufferException | RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void doCleanUpCommitCas(NonTransactionalOperationContext ctx, Set<Hash> branchCommits, Set<Hash> newKeyLists) {
        if (branchCommits.isEmpty() && newKeyLists.isEmpty()) {
            return;
        }
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            WriteBatch batch = new WriteBatch();
            for (Hash h : branchCommits) {
                batch.delete(this.dbInstance.getCfCommitLog(), this.dbKey(h));
            }
            for (Hash h : newKeyLists) {
                batch.delete(this.dbInstance.getCfKeyList(), this.dbKey(h));
            }
            this.db.write(new WriteOptions(), batch);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void doCleanUpRefLogWrite(NonTransactionalOperationContext ctx, Hash refLogId) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            this.db.delete(this.dbInstance.getCfRefLog(), this.dbKey(refLogId));
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected AdapterTypes.GlobalStateLogEntry doFetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        try {
            byte[] v = this.db.get(this.dbInstance.getCfGlobalLog(), this.dbKey(id));
            return v != null ? AdapterTypes.GlobalStateLogEntry.parseFrom((byte[])v) : null;
        }
        catch (InvalidProtocolBufferException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected CommitLogEntry doFetchFromCommitLog(NonTransactionalOperationContext ctx, Hash hash) {
        try {
            byte[] v = this.db.get(this.dbInstance.getCfCommitLog(), this.dbKey(hash));
            return ProtoSerialization.protoToCommitLogEntry((byte[])v);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<CommitLogEntry> doFetchMultipleFromCommitLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.dbInstance.getCfCommitLog(), hashes, ProtoSerialization::protoToCommitLogEntry);
    }

    protected List<AdapterTypes.GlobalStateLogEntry> doFetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.dbInstance.getCfGlobalLog(), hashes, v -> {
            try {
                return v != null ? AdapterTypes.GlobalStateLogEntry.parseFrom((byte[])v) : null;
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private <T> List<T> fetchPage(ColumnFamilyHandle cfHandle, List<Hash> hashes, Function<byte[], T> deserializer) {
        try {
            ArrayList<ColumnFamilyHandle> cf = new ArrayList<ColumnFamilyHandle>(hashes.size());
            for (int i = 0; i < hashes.size(); ++i) {
                cf.add(cfHandle);
            }
            List result = this.db.multiGetAsList(cf, hashes.stream().map(this::dbKey).collect(Collectors.toList()));
            return result.stream().map(deserializer).collect(Collectors.toList());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doWriteKeyListEntities(NonTransactionalOperationContext ctx, List<KeyListEntity> newKeyListEntities) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            for (KeyListEntity keyListEntity : newKeyListEntities) {
                byte[] key = this.dbKey(keyListEntity.getId());
                this.db.put(this.dbInstance.getCfKeyList(), key, ProtoSerialization.toProto((KeyList)keyListEntity.getKeys()).toByteArray());
            }
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected Stream<KeyListEntity> doFetchKeyLists(NonTransactionalOperationContext ctx, List<Hash> keyListsIds) {
        try {
            ArrayList<ColumnFamilyHandle> cf = new ArrayList<ColumnFamilyHandle>(keyListsIds.size());
            for (int i2 = 0; i2 < keyListsIds.size(); ++i2) {
                cf.add(this.dbInstance.getCfKeyList());
            }
            List result = this.db.multiGetAsList(cf, keyListsIds.stream().map(this::dbKey).collect(Collectors.toList()));
            return IntStream.range(0, keyListsIds.size()).mapToObj(i -> {
                byte[] v = (byte[])result.get(i);
                return KeyListEntity.of((Hash)((Hash)keyListsIds.get(i)), (KeyList)ProtoSerialization.protoToKeyList((byte[])v));
            });
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected RepoDescription doFetchRepositoryDescription(NonTransactionalOperationContext ctx) {
        try {
            byte[] bytes = this.db.get(this.dbInstance.getCfRepoProps(), this.globalPointerKey());
            return bytes != null ? ProtoSerialization.protoToRepoDescription((byte[])bytes) : null;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean doTryUpdateRepositoryDescription(NonTransactionalOperationContext ctx, RepoDescription expected, RepoDescription updateTo) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] bytes = this.db.get(this.dbInstance.getCfRepoProps(), this.globalPointerKey());
            byte[] updatedBytes = ProtoSerialization.toProto((RepoDescription)updateTo).toByteArray();
            if (bytes == null && expected == null || bytes != null && Arrays.equals(bytes, ProtoSerialization.toProto((RepoDescription)expected).toByteArray())) {
                this.db.put(this.dbInstance.getCfRepoProps(), this.globalPointerKey(), updatedBytes);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void unsafeWriteRefLogStripe(NonTransactionalOperationContext ctx, int stripe, AdapterTypes.RefLogParents refLogParents) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            this.db.put(this.dbInstance.getCfRefLogHeads(), this.dbKey(stripe), refLogParents.toByteArray());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean doRefLogParentsCas(NonTransactionalOperationContext ctx, int stripe, AdapterTypes.RefLogParents previousEntry, AdapterTypes.RefLogParents newEntry) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            AdapterTypes.RefLogParents parents;
            byte[] bytes = this.db.get(this.dbInstance.getCfRefLogHeads(), this.dbKey(stripe));
            AdapterTypes.RefLogParents refLogParents = parents = bytes != null ? AdapterTypes.RefLogParents.parseFrom((byte[])bytes) : null;
            if (previousEntry != null) {
                if (!previousEntry.equals((Object)parents)) {
                    boolean bl = false;
                    return bl;
                }
            } else if (parents != null) {
                boolean bl = false;
                return bl;
            }
            this.db.put(this.dbInstance.getCfRefLogHeads(), this.dbKey(stripe), newEntry.toByteArray());
            boolean bl = true;
            return bl;
        }
        catch (InvalidProtocolBufferException | RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected AdapterTypes.RefLogParents doFetchRefLogParents(NonTransactionalOperationContext ctx, int stripe) {
        Lock lock = this.dbInstance.getLock().readLock();
        lock.lock();
        try {
            byte[] bytes = this.db.get(this.dbInstance.getCfRefLogHeads(), this.dbKey(stripe));
            if (bytes == null) {
                AdapterTypes.RefLogParents refLogParents = null;
                return refLogParents;
            }
            AdapterTypes.RefLogParents refLogParents = AdapterTypes.RefLogParents.parseFrom((byte[])bytes);
            return refLogParents;
        }
        catch (InvalidProtocolBufferException | RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected List<AdapterTypes.ReferenceNames> doFetchReferenceNames(NonTransactionalOperationContext ctx, int segment, int prefetchSegments) {
        return IntStream.rangeClosed(segment, segment + prefetchSegments).mapToObj(seg -> {
            try {
                return this.db.get(this.dbInstance.getCfRefNames(), this.dbKey(seg));
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        }).map(s -> {
            try {
                return s != null ? AdapterTypes.ReferenceNames.parseFrom((byte[])s) : null;
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AdapterTypes.NamedReference> doFetchNamedReference(NonTransactionalOperationContext ctx, List<String> refNames) {
        Lock lock = this.dbInstance.getLock().readLock();
        lock.lock();
        try {
            List<AdapterTypes.NamedReference> list = refNames.stream().map(refName -> {
                try {
                    return this.db.get(this.dbInstance.getCfRefHeads(), this.dbKey((String)refName));
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
            }).filter(Objects::nonNull).map(serialized -> {
                try {
                    return AdapterTypes.NamedReference.parseFrom((byte[])serialized);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean doCreateNamedReference(NonTransactionalOperationContext ctx, AdapterTypes.NamedReference namedReference) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] existing = this.db.get(this.dbInstance.getCfRefHeads(), this.dbKey(namedReference.getName()));
            if (existing != null) {
                boolean bl = false;
                return bl;
            }
            this.db.put(this.dbInstance.getCfRefHeads(), this.dbKey(namedReference.getName()), namedReference.toByteArray());
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean doDeleteNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] existing = this.db.get(this.dbInstance.getCfRefHeads(), this.dbKey(ref.getName()));
            if (existing == null) {
                boolean bl = false;
                return bl;
            }
            AdapterTypes.NamedReference expected = AdapterTypes.NamedReference.newBuilder().setName(ref.getName()).setRef(refHead).build();
            if (!Arrays.equals(existing, expected.toByteArray())) {
                boolean bl = false;
                return bl;
            }
            this.db.delete(this.dbInstance.getCfRefHeads(), this.dbKey(ref.getName()));
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void doAddToNamedReferences(NonTransactionalOperationContext ctx, Stream<NamedRef> refStream, int addToSegment) {
        Set refNamesToAdd = refStream.map(NamedRef::getName).collect(Collectors.toSet());
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            AdapterTypes.ReferenceNames referenceNames;
            byte[] refNamesBytes = this.db.get(this.dbInstance.getCfRefNames(), this.dbKey(addToSegment));
            try {
                referenceNames = refNamesBytes == null ? AdapterTypes.ReferenceNames.getDefaultInstance() : AdapterTypes.ReferenceNames.parseFrom((byte[])refNamesBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            byte[] newRefNameBytes = referenceNames.toBuilder().addAllRefNames(refNamesToAdd).build().toByteArray();
            this.db.put(this.dbInstance.getCfRefNames(), this.dbKey(addToSegment), newRefNameBytes);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected void doRemoveFromNamedReferences(NonTransactionalOperationContext ctx, NamedRef ref, int removeFromSegment) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            AdapterTypes.ReferenceNames referenceNames;
            byte[] refNamesBytes = this.db.get(this.dbInstance.getCfRefNames(), this.dbKey(removeFromSegment));
            if (refNamesBytes == null) {
                return;
            }
            try {
                referenceNames = AdapterTypes.ReferenceNames.parseFrom((byte[])refNamesBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            AdapterTypes.ReferenceNames.Builder newRefNames = referenceNames.toBuilder().clearRefNames();
            referenceNames.getRefNamesList().stream().filter(n -> !n.equals(ref.getName())).forEach(arg_0 -> ((AdapterTypes.ReferenceNames.Builder)newRefNames).addRefNames(arg_0));
            byte[] newRefNameBytes = newRefNames.build().toByteArray();
            this.db.put(this.dbInstance.getCfRefNames(), this.dbKey(removeFromSegment), newRefNameBytes);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean doUpdateNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead, Hash newHead) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            AdapterTypes.NamedReference namedReference;
            byte[] existing = this.db.get(this.dbInstance.getCfRefHeads(), this.dbKey(ref.getName()));
            if (existing == null) {
                boolean bl = false;
                return bl;
            }
            try {
                namedReference = AdapterTypes.NamedReference.parseFrom((byte[])existing);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            if (!namedReference.getRef().equals((Object)refHead)) {
                boolean e = false;
                return e;
            }
            AdapterTypes.NamedReference newNamedReference = namedReference.toBuilder().setRef(namedReference.getRef().toBuilder().setHash(newHead.asBytes())).build();
            this.db.put(this.dbInstance.getCfRefHeads(), this.dbKey(ref.getName()), newNamedReference.toByteArray());
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyListEntry entry) {
        return ProtoSerialization.toProto((KeyListEntry)entry).getSerializedSize();
    }

    protected void doWriteRefLog(NonTransactionalOperationContext ctx, AdapterTypes.RefLogEntry entry) throws ReferenceConflictException {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] key = this.dbKey(entry.getRefLogId());
            this.checkForHashCollision(this.dbInstance.getCfRefLog(), key);
            this.db.put(this.dbInstance.getCfRefLog(), key, entry.toByteArray());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected RefLog doFetchFromRefLog(NonTransactionalOperationContext ctx, Hash refLogId) {
        Objects.requireNonNull(refLogId, "refLogId mut not be null");
        try {
            byte[] v = this.db.get(this.dbInstance.getCfRefLog(), this.dbKey(refLogId));
            return ProtoSerialization.protoToRefLog((byte[])v);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<RefLog> doFetchPageFromRefLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.dbInstance.getCfRefLog(), hashes, ProtoSerialization::protoToRefLog);
    }

    private void checkForHashCollision(ColumnFamilyHandle cf, byte[] key) throws ReferenceConflictException, RocksDBException {
        Holder value = new Holder();
        if (this.db.keyMayExist(cf, key, value) && value.getValue() != null) {
            throw DatabaseAdapterUtil.hashCollisionDetected();
        }
    }

    protected Stream<CommitLogEntry> doScanAllCommitLogEntries(NonTransactionalOperationContext c) {
        final RocksIterator iter = this.db.newIterator(this.dbInstance.getCfCommitLog());
        iter.seekToFirst();
        Spliterators.AbstractSpliterator<CommitLogEntry> split = new Spliterators.AbstractSpliterator<CommitLogEntry>(Long.MAX_VALUE, 256){

            @Override
            public boolean tryAdvance(Consumer<? super CommitLogEntry> action) {
                if (!iter.isValid()) {
                    return false;
                }
                ByteString key = ByteString.copyFrom((byte[])iter.key());
                if (key.startsWith(RocksDatabaseAdapter.this.keyPrefix)) {
                    action.accept((CommitLogEntry)ProtoSerialization.protoToCommitLogEntry((byte[])iter.value()));
                }
                iter.next();
                return true;
            }
        };
        return (Stream)StreamSupport.stream(split, false).onClose(() -> ((RocksIterator)iter).close());
    }

    protected void writeAttachments(Stream<Map.Entry<AdapterTypes.AttachmentKey, AdapterTypes.AttachmentValue>> attachments) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            attachments.forEach(b -> {
                try {
                    this.storeAttachmentKey((AdapterTypes.AttachmentKey)b.getKey());
                    this.db.put(this.dbInstance.getCfAttachments(), this.dbKey(((AdapterTypes.AttachmentKey)b.getKey()).toByteString()), ((AdapterTypes.AttachmentValue)b.getValue()).toByteArray());
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean consistentWriteAttachment(AdapterTypes.AttachmentKey key, AdapterTypes.AttachmentValue value, Optional<String> expectedVersion) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            byte[] dbKey;
            block14: {
                byte[] current;
                block13: {
                    block12: {
                        dbKey = this.dbKey(key.toByteString());
                        current = this.db.get(this.dbInstance.getCfAttachments(), dbKey);
                        if (!expectedVersion.isPresent()) break block13;
                        try {
                            if (current != null) break block12;
                            boolean bl = false;
                            return bl;
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    AdapterTypes.AttachmentValue val = AdapterTypes.AttachmentValue.parseFrom((byte[])current);
                    if (!val.hasVersion() || !val.getVersion().equals(expectedVersion.get())) {
                        boolean bl = false;
                        return bl;
                    }
                    break block14;
                }
                if (current != null) {
                    boolean bl = false;
                    return bl;
                }
                this.storeAttachmentKey(key);
            }
            this.db.put(this.dbInstance.getCfAttachments(), dbKey, value.toByteArray());
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private void storeAttachmentKey(AdapterTypes.AttachmentKey attachmentKey) throws RocksDBException {
        AdapterTypes.AttachmentKeyList.Builder keyList;
        byte[] dbKey = this.dbKey(attachmentKey.getContentId().toByteString());
        byte[] old = this.db.get(this.dbInstance.getCfAttachmentKeys(), dbKey);
        if (old == null) {
            keyList = AdapterTypes.AttachmentKeyList.newBuilder().addKeys(attachmentKey);
        } else {
            try {
                keyList = (AdapterTypes.AttachmentKeyList.Builder)AdapterTypes.AttachmentKeyList.newBuilder().mergeFrom(old);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            if (!keyList.getKeysList().contains(attachmentKey)) {
                keyList.addKeys(attachmentKey);
            }
        }
        this.db.put(this.dbInstance.getCfAttachmentKeys(), dbKey, keyList.build().toByteArray());
    }

    private void removeAttachmentKey(AdapterTypes.AttachmentKey attachmentKey) throws RocksDBException {
        AdapterTypes.AttachmentKeyList.Builder keyList;
        byte[] dbKey = this.dbKey(attachmentKey.getContentId().toByteString());
        byte[] old = this.db.get(this.dbInstance.getCfAttachmentKeys(), dbKey);
        if (old == null) {
            return;
        }
        try {
            keyList = (AdapterTypes.AttachmentKeyList.Builder)AdapterTypes.AttachmentKeyList.newBuilder().mergeFrom(old);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < keyList.getKeysList().size(); ++i) {
            if (!keyList.getKeys(i).equals((Object)attachmentKey)) continue;
            keyList.removeKeys(i);
            break;
        }
        this.db.put(this.dbInstance.getCfAttachmentKeys(), dbKey, keyList.build().toByteArray());
    }

    protected Stream<AdapterTypes.AttachmentKey> fetchAttachmentKeys(String contentId) {
        try {
            AdapterTypes.AttachmentKeyList keyList;
            byte[] dbKey = this.dbKey(AdapterTypes.ContentId.newBuilder().setId(contentId).build().toByteString());
            byte[] attachmentKeys = this.db.get(this.dbInstance.getCfAttachmentKeys(), dbKey);
            if (attachmentKeys == null) {
                return Stream.empty();
            }
            try {
                keyList = AdapterTypes.AttachmentKeyList.parseFrom((byte[])attachmentKeys);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            return keyList.getKeysList().stream();
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected Stream<Map.Entry<AdapterTypes.AttachmentKey, AdapterTypes.AttachmentValue>> fetchAttachments(Stream<AdapterTypes.AttachmentKey> keys) {
        try {
            List keyList = keys.collect(Collectors.toList());
            if (keyList.isEmpty()) {
                return Stream.empty();
            }
            List<ColumnFamilyHandle> handles = Collections.nCopies(keyList.size(), this.dbInstance.getCfAttachments());
            List result = this.db.multiGetAsList(handles, keyList.stream().map(k -> this.dbKey(k.toByteString())).collect(Collectors.toList()));
            return IntStream.range(0, keyList.size()).mapToObj(i -> {
                byte[] r = (byte[])result.get(i);
                if (r == null) {
                    return null;
                }
                try {
                    return Maps.immutableEntry((Object)((AdapterTypes.AttachmentKey)keyList.get(i)), (Object)AdapterTypes.AttachmentValue.parseFrom((byte[])r));
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }).filter(Objects::nonNull);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    protected void purgeAttachments(Stream<AdapterTypes.AttachmentKey> keys) {
        Lock lock = this.dbInstance.getLock().writeLock();
        lock.lock();
        try {
            keys.forEach(k -> {
                try {
                    this.db.delete(this.dbInstance.getCfAttachments(), this.dbKey(k.toByteString()));
                    this.removeAttachmentKey((AdapterTypes.AttachmentKey)k);
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            lock.unlock();
        }
    }
}

