/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.rocks;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionProvider;
import org.projectnessie.versioned.persist.rocks.RocksDbConfig;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TransactionDB;
import org.rocksdb.TransactionDBOptions;

public class RocksDbInstance
implements DatabaseConnectionProvider<RocksDbConfig> {
    private TransactionDB db;
    private String dbPath;
    public static final String CF_REPO_PROPS = "repo_props";
    public static final String CF_GLOBAL_POINTER = "global_pointer";
    public static final String CF_GLOBAL_LOG = "global_log";
    public static final String CF_COMMIT_LOG = "commit_log";
    public static final String CF_KEY_LIST = "key_list";
    public static final String CF_REF_LOG = "ref_log";
    static final String CF_REF_HEADS = "ref_heads";
    static final String CF_REF_NAMES = "ref_names";
    static final String CF_REF_LOG_HEADS = "ref_log_heads";
    public static final String CF_ATTACHMENTS = "attachments";
    public static final String CF_ATTACHMENT_KEYS = "attachment_keys";
    private static final List<String> CF_ALL = Arrays.asList("repo_props", "global_pointer", "global_log", "commit_log", "key_list", "ref_log", "ref_heads", "ref_names", "ref_log_heads", "attachments", "attachment_keys");
    private ColumnFamilyHandle cfRepoProps;
    private ColumnFamilyHandle cfGlobalPointer;
    private ColumnFamilyHandle cfGlobalLog;
    private ColumnFamilyHandle cfCommitLog;
    private ColumnFamilyHandle cfKeyList;
    private ColumnFamilyHandle cfRefLog;
    private ColumnFamilyHandle cfRefHeads;
    private ColumnFamilyHandle cfRefNames;
    private ColumnFamilyHandle cfRefLogHeads;
    private ColumnFamilyHandle cfAttachments;
    private ColumnFamilyHandle cfAttachmentKeys;
    private final ReadWriteLock lock = new StampedLock().asReadWriteLock();

    public RocksDbInstance() {
        RocksDB.loadLibrary();
    }

    public void configure(RocksDbConfig config) {
        this.dbPath = config.getDbPath();
    }

    public synchronized void close() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            finally {
                this.db = null;
            }
        }
    }

    public synchronized void initialize() {
        if (this.db == null) {
            if (this.dbPath == null || this.dbPath.trim().isEmpty()) {
                throw new IllegalStateException("RocksDB instance missing dbPath option.");
            }
            ArrayList<byte[]> columnFamilies = new ArrayList<byte[]>();
            columnFamilies.add(RocksDB.DEFAULT_COLUMN_FAMILY);
            CF_ALL.stream().map(s -> s.getBytes(StandardCharsets.UTF_8)).forEach(columnFamilies::add);
            List columnFamilyDescriptors = columnFamilies.stream().map(c -> new ColumnFamilyDescriptor(c, new ColumnFamilyOptions().optimizeUniversalStyleCompaction())).collect(Collectors.toList());
            try (DBOptions dbOptions = new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true);){
                ArrayList columnFamilyHandles = new ArrayList();
                this.db = TransactionDB.open((DBOptions)dbOptions, (TransactionDBOptions)new TransactionDBOptions(), (String)this.dbPath, columnFamilyDescriptors, columnFamilyHandles);
                HashMap<String, ColumnFamilyHandle> columnFamilyHandleMap = new HashMap<String, ColumnFamilyHandle>();
                for (int i = 0; i < CF_ALL.size(); ++i) {
                    String cf = CF_ALL.get(i);
                    columnFamilyHandleMap.put(cf, (ColumnFamilyHandle)columnFamilyHandles.get(i + 1));
                }
                this.cfRepoProps = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_REPO_PROPS);
                this.cfGlobalPointer = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_GLOBAL_POINTER);
                this.cfGlobalLog = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_GLOBAL_LOG);
                this.cfCommitLog = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_COMMIT_LOG);
                this.cfKeyList = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_KEY_LIST);
                this.cfRefLog = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_REF_LOG);
                this.cfRefHeads = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_REF_HEADS);
                this.cfRefNames = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_REF_NAMES);
                this.cfRefLogHeads = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_REF_LOG_HEADS);
                this.cfAttachments = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_ATTACHMENTS);
                this.cfAttachmentKeys = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_ATTACHMENT_KEYS);
            }
            catch (RocksDBException e) {
                throw new RuntimeException("RocksDB failed to start", e);
            }
        }
    }

    public ColumnFamilyHandle getCfRepoProps() {
        return this.cfRepoProps;
    }

    public ColumnFamilyHandle getCfGlobalPointer() {
        return this.cfGlobalPointer;
    }

    public ColumnFamilyHandle getCfGlobalLog() {
        return this.cfGlobalLog;
    }

    public ColumnFamilyHandle getCfCommitLog() {
        return this.cfCommitLog;
    }

    public ColumnFamilyHandle getCfKeyList() {
        return this.cfKeyList;
    }

    public ColumnFamilyHandle getCfRefLog() {
        return this.cfRefLog;
    }

    public ColumnFamilyHandle getCfRefHeads() {
        return this.cfRefHeads;
    }

    public ColumnFamilyHandle getCfRefNames() {
        return this.cfRefNames;
    }

    public ColumnFamilyHandle getCfRefLogHeads() {
        return this.cfRefLogHeads;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public TransactionDB getDb() {
        return this.db;
    }

    public ColumnFamilyHandle getCfAttachments() {
        return this.cfAttachments;
    }

    public ColumnFamilyHandle getCfAttachmentKeys() {
        return this.cfAttachmentKeys;
    }

    public Stream<ColumnFamilyHandle> allExceptGlobalPointer() {
        return Stream.of(this.cfGlobalLog, this.cfCommitLog, this.cfRepoProps, this.cfKeyList, this.cfRefLog, this.cfRefHeads, this.cfRefNames, this.cfRefLogHeads, this.cfAttachments, this.cfAttachmentKeys);
    }
}

