/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests.extension;

import java.util.function.Function;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionProvider;
import org.projectnessie.versioned.persist.tests.extension.TestConnectionProviderSource;

public abstract class AbstractTestConnectionProviderSource<CONN_CONFIG extends DatabaseConnectionConfig>
implements TestConnectionProviderSource<CONN_CONFIG> {
    private CONN_CONFIG config;
    private DatabaseConnectionProvider<CONN_CONFIG> connectionProvider;

    @Override
    public void configureConnectionProviderConfigFromDefaults(Function<CONN_CONFIG, CONN_CONFIG> configurer) {
        Object config = this.createDefaultConnectionProviderConfig();
        config = (DatabaseConnectionConfig)configurer.apply(config);
        this.setConnectionProviderConfig(config);
    }

    @Override
    public void setConnectionProviderConfig(CONN_CONFIG connectionProviderConfig) {
        this.config = connectionProviderConfig;
    }

    @Override
    public DatabaseConnectionProvider<CONN_CONFIG> getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public CONN_CONFIG getConnectionProviderConfig() {
        return this.config;
    }

    protected abstract DatabaseConnectionProvider<CONN_CONFIG> createConnectionProvider();

    @Override
    public void start() throws Exception {
        if (this.connectionProvider != null) {
            throw new IllegalStateException("Already started");
        }
        this.connectionProvider = this.createConnectionProvider();
        this.connectionProvider.configure(this.config);
        this.connectionProvider.initialize();
    }

    @Override
    public void stop() throws Exception {
        try {
            if (this.connectionProvider != null) {
                this.connectionProvider.close();
            }
        }
        finally {
            this.connectionProvider = null;
        }
    }
}

