/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.projectnessie.versioned.TracingVersionStore;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.persist.adapter.AdjustableDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterFactory;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionProvider;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.spi.TracingDatabaseAdapter;
import org.projectnessie.versioned.persist.store.PersistVersionStore;
import org.projectnessie.versioned.persist.tests.SystemPropertiesConfigurer;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterConfigItem;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterName;
import org.projectnessie.versioned.persist.tests.extension.NessieExternalDatabase;
import org.projectnessie.versioned.persist.tests.extension.TestConnectionProviderSource;

public class DatabaseAdapterExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{DatabaseAdapterExtension.class});
    private static final String KEY_STATICS = "static-adapters";

    private static void reinit(DatabaseAdapter adapter) {
        adapter.eraseRepo();
        adapter.initializeRepo("main");
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        ClassDbAdapters classDbAdapters = (ClassDbAdapters)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)KEY_STATICS, k -> new ClassDbAdapters(testClass), ClassDbAdapters.class);
        AnnotationUtils.findAnnotatedFields((Class)testClass, NessieDbAdapter.class, ReflectionUtils::isStatic).forEach(field -> this.injectField(context, (Field)field, classDbAdapters::newDatabaseAdapter));
    }

    public void beforeEach(ExtensionContext context) {
        ((ClassDbAdapters)context.getStore((ExtensionContext.Namespace)DatabaseAdapterExtension.NAMESPACE).get((Object)KEY_STATICS, ClassDbAdapters.class)).adapters.forEach(DatabaseAdapterExtension::reinit);
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> AnnotationUtils.findAnnotatedFields(instance.getClass(), NessieDbAdapter.class, ReflectionUtils::isNotStatic).forEach(field -> this.injectField(context, (Field)field, adapter -> {
            if (field.getAnnotation(NessieDbAdapter.class).initializeRepo()) {
                DatabaseAdapterExtension.reinit(adapter);
            }
        })));
    }

    public void afterEach(ExtensionContext context) {
        ((ClassDbAdapters)context.getStore((ExtensionContext.Namespace)DatabaseAdapterExtension.NAMESPACE).get((Object)KEY_STATICS, ClassDbAdapters.class)).adapters.forEach(DatabaseAdapter::assertCleanStateForTests);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(NessieDbAdapter.class);
    }

    private void injectField(ExtensionContext context, Field field, Consumer<DatabaseAdapter> newAdapter) {
        this.assertValidFieldCandidate(field);
        try {
            NessieDbAdapter nessieDbAdapter = (NessieDbAdapter)AnnotationUtils.findAnnotation((AnnotatedElement)field, NessieDbAdapter.class).orElseThrow(IllegalStateException::new);
            Object assign = this.resolve(nessieDbAdapter, field, field.getType(), context, null, field, false, newAdapter);
            ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(context.getTestInstance().orElse(null), assign);
        }
        catch (Throwable t) {
            ExceptionUtils.throwAsUncheckedException((Throwable)t);
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        NessieDbAdapter nessieDbAdapter = (NessieDbAdapter)parameterContext.findAnnotation(NessieDbAdapter.class).orElseThrow(IllegalStateException::new);
        Parameter parameter = parameterContext.getParameter();
        return this.resolve(nessieDbAdapter, parameter, parameter.getType(), context, parameterContext, null, true, adapter -> {});
    }

    private Object resolve(NessieDbAdapter nessieDbAdapter, AnnotatedElement annotatedElement, Class<?> type, ExtensionContext context, ParameterContext parameterContext, Field field, boolean canReinit, Consumer<DatabaseAdapter> newAdapter) {
        DatabaseAdapter assign;
        DatabaseAdapter databaseAdapter = DatabaseAdapterExtension.createAdapterResource(nessieDbAdapter, context, parameterContext, field);
        if (nessieDbAdapter.withTracing()) {
            databaseAdapter = new TracingDatabaseAdapter(databaseAdapter);
        }
        if (canReinit && nessieDbAdapter.initializeRepo()) {
            DatabaseAdapterExtension.reinit(databaseAdapter);
        }
        if (DatabaseAdapter.class.isAssignableFrom(type)) {
            assign = databaseAdapter;
        } else if (VersionStore.class.isAssignableFrom(type)) {
            PersistVersionStore store = new PersistVersionStore(databaseAdapter);
            if (nessieDbAdapter.withTracing()) {
                store = new TracingVersionStore((VersionStore)store);
            }
            assign = store;
        } else {
            throw new IllegalStateException("Cannot assign to " + annotatedElement);
        }
        newAdapter.accept(databaseAdapter);
        if (assign != null && !type.isAssignableFrom(assign.getClass())) {
            throw new IllegalStateException(String.format("Cannot assign %s to %s", assign.getClass(), annotatedElement));
        }
        return assign;
    }

    static <A extends Annotation> Optional<A> findAnnotation(ExtensionContext context, Field field, ParameterContext parameterContext, Class<A> annotation) {
        A fieldAnnotation;
        Optional opt;
        if (parameterContext != null && (opt = parameterContext.findAnnotation(annotation)).isPresent()) {
            return opt;
        }
        if (field != null && (fieldAnnotation = field.getAnnotation(annotation)) != null) {
            return Optional.of(fieldAnnotation);
        }
        opt = context.getTestMethod().flatMap(m -> AnnotationUtils.findAnnotation((AnnotatedElement)m, (Class)annotation));
        if (opt.isPresent()) {
            return opt;
        }
        opt = context.getTestClass().flatMap(m -> AnnotationUtils.findAnnotation((AnnotatedElement)m, (Class)annotation));
        return opt;
    }

    static DatabaseAdapter createAdapterResource(NessieDbAdapter adapterAnnotation, ExtensionContext context, ParameterContext parameterContext, Field field) {
        DatabaseAdapterFactory factory = DatabaseAdapterExtension.findAnnotation(context, field, parameterContext, NessieDbAdapterName.class).map(NessieDbAdapterName::value).map(DatabaseAdapterFactory::loadFactoryByName).orElseGet(() -> DatabaseAdapterFactory.loadFactory(x -> true));
        Function<AdjustableDatabaseAdapterConfig, DatabaseAdapterConfig> applyCustomConfig = DatabaseAdapterExtension.extractCustomConfiguration(adapterAnnotation, context);
        DatabaseAdapterFactory.Builder builder = factory.newBuilder();
        if (adapterAnnotation.eventConsumer() != AdapterEventConsumer.class) {
            AdapterEventConsumer eventConsumer;
            try {
                Constructor<? extends AdapterEventConsumer> ctor = adapterAnnotation.eventConsumer().getDeclaredConstructor(new Class[0]);
                ReflectionUtils.makeAccessible(ctor);
                eventConsumer = ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to instantiate AdapterEventConsumer of type %s", adapterAnnotation.eventConsumer()), e);
            }
            builder.withEventConsumer(eventConsumer);
        }
        builder.configure(c -> SystemPropertiesConfigurer.configureAdapterFromProperties(c, property -> {
            ArrayList configs = new ArrayList();
            if (parameterContext != null) {
                configs.addAll(parameterContext.findRepeatableAnnotations(NessieDbAdapterConfigItem.class));
            }
            Consumer<AnnotatedElement> collector = m -> configs.addAll(AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)m, NessieDbAdapterConfigItem.class));
            if (field != null) {
                collector.accept(field);
            }
            context.getTestMethod().ifPresent(collector);
            context.getTestClass().ifPresent(cls -> {
                while (cls != Object.class) {
                    collector.accept((AnnotatedElement)cls);
                    cls = cls.getSuperclass();
                }
            });
            return configs.stream().filter(n -> ("nessie.store." + n.name()).equals(property)).findFirst().map(NessieDbAdapterConfigItem::value).orElse(null);
        })).configure(applyCustomConfig).withConnector(DatabaseAdapterExtension.getConnectionProvider(context));
        return (DatabaseAdapter)builder.build();
    }

    private static Function<AdjustableDatabaseAdapterConfig, DatabaseAdapterConfig> extractCustomConfiguration(NessieDbAdapter adapterAnnotation, ExtensionContext context) {
        Function<AdjustableDatabaseAdapterConfig, DatabaseAdapterConfig> applyCustomConfig = c -> c;
        if (!adapterAnnotation.configMethod().isEmpty()) {
            Method configMethod = (Method)ReflectionUtils.findMethod((Class)context.getRequiredTestClass(), (String)adapterAnnotation.configMethod(), (Class[])new Class[]{AdjustableDatabaseAdapterConfig.class}).orElseThrow(() -> new IllegalArgumentException(String.format("%s.configMethod='%s' does not exist in %s", NessieDbAdapter.class.getSimpleName(), adapterAnnotation.configMethod(), context.getRequiredTestClass().getName())));
            ReflectionUtils.makeAccessible((AccessibleObject)configMethod);
            if (!Modifier.isStatic(configMethod.getModifiers()) || Modifier.isPrivate(configMethod.getModifiers()) || !DatabaseAdapterConfig.class.isAssignableFrom(configMethod.getReturnType())) {
                throw new IllegalArgumentException(String.format("%s.configMethod='%s' must have the signature 'static %s %s(%s)' in %s", NessieDbAdapter.class.getSimpleName(), adapterAnnotation.configMethod(), DatabaseAdapterConfig.class.getSimpleName(), adapterAnnotation.configMethod(), AdjustableDatabaseAdapterConfig.class.getSimpleName(), context.getRequiredTestClass().getName()));
            }
            applyCustomConfig = c -> {
                try {
                    return (DatabaseAdapterConfig)configMethod.invoke(null, c);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return applyCustomConfig;
    }

    private static <CONNECTOR extends DatabaseConnectionProvider<?>> CONNECTOR getConnectionProvider(ExtensionContext context) {
        TestConnectionProviderSource<?> connectionProvider = ((ClassDbAdapters)context.getStore((ExtensionContext.Namespace)DatabaseAdapterExtension.NAMESPACE).get((Object)KEY_STATICS, ClassDbAdapters.class)).connectionProvider;
        if (connectionProvider == null) {
            throw new NullPointerException("connectionProvider not configured");
        }
        return (CONNECTOR)connectionProvider.getConnectionProvider();
    }

    private void assertValidFieldCandidate(Field field) {
        if (!field.getType().isAssignableFrom(DatabaseAdapter.class) && !field.getType().isAssignableFrom(VersionStore.class)) {
            throw new ExtensionConfigurationException("Can only resolve fields of type " + VersionStore.class.getName() + " or " + DatabaseAdapter.class.getName() + " but was: " + field.getType().getName());
        }
        if (ReflectionUtils.isPrivate((Member)field)) {
            throw new ExtensionConfigurationException(String.format("field [%s] must not be private.", field));
        }
    }

    private static class ClassDbAdapters
    implements ExtensionContext.Store.CloseableResource {
        final List<DatabaseAdapter> adapters = new ArrayList<DatabaseAdapter>();
        TestConnectionProviderSource<?> connectionProvider;

        ClassDbAdapters(Class<?> testClass) {
            TestConnectionProviderSource<?> connectionProvider;
            NessieExternalDatabase external = (NessieExternalDatabase)AnnotationUtils.findAnnotation(testClass, NessieExternalDatabase.class).orElseThrow(() -> new IllegalStateException(String.format("Mandatory @%s missing for test class %s", NessieExternalDatabase.class.getSimpleName(), testClass.getName())));
            try {
                connectionProvider = external.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                connectionProvider.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.connectionProvider = connectionProvider;
        }

        public void close() throws Exception {
            if (this.connectionProvider != null) {
                try {
                    this.connectionProvider.stop();
                }
                finally {
                    this.connectionProvider = null;
                }
            }
        }

        void newDatabaseAdapter(DatabaseAdapter adapter) {
            this.adapters.add(adapter);
        }
    }
}

