/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableRepoDescription;
import org.projectnessie.versioned.persist.adapter.RepoDescription;

public abstract class AbstractRepoDescription {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractRepoDescription(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    @Test
    void emptyIsDefault() throws Exception {
        Assertions.assertThat((Object)this.databaseAdapter.fetchRepositoryDescription()).isEqualTo((Object)RepoDescription.DEFAULT);
        this.databaseAdapter.updateRepositoryDescription(d -> {
            Assertions.assertThat((Object)d).isEqualTo((Object)RepoDescription.DEFAULT);
            return null;
        });
    }

    @Test
    void updates() throws Exception {
        ImmutableRepoDescription update1 = RepoDescription.builder().repoVersion(42).putProperties("a", "b").putProperties("c", "d").build();
        ImmutableRepoDescription update2 = RepoDescription.builder().repoVersion(666).putProperties("a", "e").putProperties("c", "f").build();
        this.databaseAdapter.updateRepositoryDescription(arg_0 -> AbstractRepoDescription.lambda$updates$1((RepoDescription)update1, arg_0));
        Assertions.assertThat((Object)this.databaseAdapter.fetchRepositoryDescription()).isEqualTo((Object)update1);
        this.databaseAdapter.updateRepositoryDescription(arg_0 -> AbstractRepoDescription.lambda$updates$2((RepoDescription)update1, (RepoDescription)update2, arg_0));
        Assertions.assertThat((Object)this.databaseAdapter.fetchRepositoryDescription()).isEqualTo((Object)update2);
    }

    private static /* synthetic */ RepoDescription lambda$updates$2(RepoDescription update1, RepoDescription update2, RepoDescription d) {
        Assertions.assertThat((Object)d).isEqualTo((Object)update1);
        return update2;
    }

    private static /* synthetic */ RepoDescription lambda$updates$1(RepoDescription update1, RepoDescription d) {
        Assertions.assertThat((Object)d).isEqualTo((Object)RepoDescription.DEFAULT);
        return update1;
    }
}

